/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Locale;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DefaultTimestampFormatter;
import org.apache.spark.sql.catalyst.util.FractionTimestampFormatter;
import org.apache.spark.sql.catalyst.util.Iso8601TimestampFormatter;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.LegacyFastTimestampFormatter;
import org.apache.spark.sql.catalyst.util.LegacySimpleTimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SqlApiConf$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;

public final class TimestampFormatter$
implements scala.Serializable {
    public static TimestampFormatter$ MODULE$;
    private final Locale defaultLocale;

    static {
        new TimestampFormatter$();
    }

    public Locale defaultLocale() {
        return this.defaultLocale;
    }

    public String defaultPattern() {
        return new StringBuilder(9).append(DateFormatter$.MODULE$.defaultPattern()).append(" HH:mm:ss").toString();
    }

    private TimestampFormatter getFormatter(Option<String> format, ZoneId zoneId, Locale locale, Enumeration.Value legacyFormat, boolean isParsing, boolean forTimestampNTZ) {
        Enumeration.Value value = SqlApiConf$.MODULE$.get().legacyTimeParserPolicy();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        TimestampFormatter formatter = !(value != null ? !value.equals(value2) : value2 != null) && !forTimestampNTZ ? this.getLegacyFormatter((String)format.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.defaultPattern()), zoneId, locale, legacyFormat) : (TimestampFormatter)format.map((Function1 & Serializable & scala.Serializable)x$9 -> new Iso8601TimestampFormatter((String)x$9, zoneId, locale, legacyFormat, isParsing)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new DefaultTimestampFormatter(zoneId, locale, legacyFormat, isParsing));
        formatter.validatePatternString(!forTimestampNTZ);
        return formatter;
    }

    private Locale getFormatter$default$3() {
        return this.defaultLocale();
    }

    private Enumeration.Value getFormatter$default$4() {
        return LegacyDateFormats$.MODULE$.LENIENT_SIMPLE_DATE_FORMAT();
    }

    private boolean getFormatter$default$6() {
        return false;
    }

    public TimestampFormatter getLegacyFormatter(String pattern, ZoneId zoneId, Locale locale, Enumeration.Value legacyFormat) {
        Enumeration.Value value = legacyFormat;
        Enumeration.Value value2 = LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return new LegacyFastTimestampFormatter(pattern, zoneId, locale);
        }
        Enumeration.Value value4 = LegacyDateFormats$.MODULE$.SIMPLE_DATE_FORMAT();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return new LegacySimpleTimestampFormatter(pattern, zoneId, locale, false);
        }
        Enumeration.Value value6 = LegacyDateFormats$.MODULE$.LENIENT_SIMPLE_DATE_FORMAT();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return new LegacySimpleTimestampFormatter(pattern, zoneId, locale, true);
        }
        throw new MatchError((Object)value);
    }

    public TimestampFormatter apply(Option<String> format, ZoneId zoneId, Locale locale, Enumeration.Value legacyFormat, boolean isParsing) {
        return this.getFormatter(format, zoneId, locale, legacyFormat, isParsing, this.getFormatter$default$6());
    }

    public TimestampFormatter apply(String format, ZoneId zoneId, Locale locale, Enumeration.Value legacyFormat, boolean isParsing) {
        return this.getFormatter((Option<String>)new Some((Object)format), zoneId, locale, legacyFormat, isParsing, this.getFormatter$default$6());
    }

    public TimestampFormatter apply(String format, ZoneId zoneId, Enumeration.Value legacyFormat, boolean isParsing) {
        return this.getFormatter((Option<String>)new Some((Object)format), zoneId, this.defaultLocale(), legacyFormat, isParsing, this.getFormatter$default$6());
    }

    public TimestampFormatter apply(Option<String> format, ZoneId zoneId, Enumeration.Value legacyFormat, boolean isParsing, boolean forTimestampNTZ) {
        return this.getFormatter(format, zoneId, this.defaultLocale(), legacyFormat, isParsing, forTimestampNTZ);
    }

    public TimestampFormatter apply(String format, ZoneId zoneId, Enumeration.Value legacyFormat, boolean isParsing, boolean forTimestampNTZ) {
        return this.getFormatter((Option<String>)new Some((Object)format), zoneId, this.defaultLocale(), legacyFormat, isParsing, forTimestampNTZ);
    }

    public TimestampFormatter apply(String format, ZoneId zoneId, boolean isParsing) {
        Some x$1 = new Some((Object)format);
        ZoneId x$2 = zoneId;
        boolean x$3 = isParsing;
        Locale x$4 = this.getFormatter$default$3();
        Enumeration.Value x$5 = this.getFormatter$default$4();
        boolean x$6 = this.getFormatter$default$6();
        return this.getFormatter((Option<String>)x$1, x$2, x$4, x$5, x$3, x$6);
    }

    public TimestampFormatter apply(String format, ZoneId zoneId, boolean isParsing, boolean forTimestampNTZ) {
        Some x$1 = new Some((Object)format);
        ZoneId x$2 = zoneId;
        boolean x$3 = isParsing;
        boolean x$4 = forTimestampNTZ;
        Locale x$5 = this.getFormatter$default$3();
        Enumeration.Value x$6 = this.getFormatter$default$4();
        return this.getFormatter((Option<String>)x$1, x$2, x$5, x$6, x$3, x$4);
    }

    public TimestampFormatter apply(ZoneId zoneId) {
        None$ x$1 = None$.MODULE$;
        ZoneId x$2 = zoneId;
        boolean x$3 = false;
        Locale x$4 = this.getFormatter$default$3();
        Enumeration.Value x$5 = this.getFormatter$default$4();
        boolean x$6 = this.getFormatter$default$6();
        return this.getFormatter((Option<String>)x$1, x$2, x$4, x$5, x$3, x$6);
    }

    public TimestampFormatter getFractionFormatter(ZoneId zoneId) {
        return new FractionTimestampFormatter(zoneId);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TimestampFormatter$() {
        MODULE$ = this;
        this.defaultLocale = Locale.US;
    }
}

