/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.io.filter.FilterContext;
import org.apache.orc.impl.InStream;
import org.apache.orc.impl.PositionProvider;
import org.apache.orc.impl.RunLengthByteReader;
import org.apache.orc.impl.TreeReaderFactory;

public final class BitFieldReader {
    private final RunLengthByteReader input;
    private int current;
    private byte currentIdx = (byte)8;

    public BitFieldReader(InStream input) {
        this.input = new RunLengthByteReader(input);
    }

    private void readByte() throws IOException {
        if (!this.input.hasNext()) {
            throw new EOFException("Read past end of bit field from " + this);
        }
        this.current = 0xFF & this.input.next();
        this.currentIdx = 0;
    }

    public int next() throws IOException {
        if (this.currentIdx > 7) {
            this.readByte();
        }
        this.currentIdx = (byte)(this.currentIdx + 1);
        return this.current >>> 8 - this.currentIdx & 1;
    }

    public void nextVector(LongColumnVector previous, FilterContext filterContext, long previousLen) throws IOException {
        previous.isRepeating = false;
        int previousIdx = 0;
        if (previous.noNulls) {
            for (int i = 0; i != filterContext.getSelectedSize(); ++i) {
                int idx = filterContext.getSelected()[i];
                if (idx - previousIdx > 0) {
                    this.skip(idx - previousIdx);
                }
                previous.vector[idx] = this.next();
                previousIdx = idx + 1;
            }
            this.skip(previousLen - (long)previousIdx);
        } else {
            for (int i = 0; i != filterContext.getSelectedSize(); ++i) {
                int idx = filterContext.getSelected()[i];
                if (idx - previousIdx > 0) {
                    this.skip(TreeReaderFactory.TreeReader.countNonNullRowsInRange(previous.isNull, previousIdx, idx));
                }
                previous.vector[idx] = !previous.isNull[idx] ? (long)this.next() : 1L;
                previousIdx = idx + 1;
            }
            this.skip(TreeReaderFactory.TreeReader.countNonNullRowsInRange(previous.isNull, previousIdx, (int)previousLen));
        }
    }

    public void nextVector(LongColumnVector previous, long previousLen) throws IOException {
        previous.isRepeating = true;
        int i = 0;
        while ((long)i < previousLen) {
            previous.vector[i] = previous.noNulls || !previous.isNull[i] ? (long)this.next() : 1L;
            if (previous.isRepeating && i > 0 && (previous.vector[0] != previous.vector[i] || previous.isNull[0] != previous.isNull[i])) {
                previous.isRepeating = false;
            }
            ++i;
        }
    }

    public void seek(PositionProvider index) throws IOException {
        this.input.seek(index);
        int consumed = (int)index.getNext();
        if (consumed > 8) {
            throw new IllegalArgumentException("Seek past end of byte at " + consumed + " in " + this.input);
        }
        if (consumed != 0) {
            this.readByte();
            this.currentIdx = (byte)consumed;
        } else {
            this.currentIdx = (byte)8;
        }
    }

    public void skip(long totalBits) throws IOException {
        int availableBits = 8 - this.currentIdx;
        if (totalBits <= (long)availableBits) {
            this.currentIdx = (byte)((long)this.currentIdx + totalBits);
        } else {
            long bitsToSkip = totalBits - (long)availableBits;
            this.input.skip(bitsToSkip / 8L);
            if (this.input.hasNext()) {
                this.current = this.input.next();
                this.currentIdx = (byte)(bitsToSkip % 8L);
            }
        }
    }

    public String toString() {
        return "bit reader current: " + this.current + " current bit index: " + this.currentIdx + " from " + this.input;
    }
}

