/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Optional;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRecordUploadToken {
    private static Logger LOG = LoggerFactory.getLogger(DataRecordUploadToken.class);
    private String blobId;
    private Optional<String> uploadId;

    public DataRecordUploadToken(@NotNull String blobId, @Nullable String uploadId) {
        this.blobId = blobId;
        this.uploadId = Optional.ofNullable(uploadId);
    }

    public static DataRecordUploadToken fromEncodedToken(@NotNull String encoded, @NotNull byte[] secret) throws IllegalArgumentException {
        String[] parts = encoded.split("#", 2);
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid upload token");
        }
        String expectedSig = parts[1];
        String toBeDecoded = parts[0];
        String actualSig = DataRecordUploadToken.getSignedString(toBeDecoded, secret);
        if (!expectedSig.equals(actualSig)) {
            throw new IllegalArgumentException("Invalid upload token");
        }
        String decoded = DataRecordUploadToken.decodeBase64(toBeDecoded);
        String[] decodedParts = decoded.split("#");
        if (decodedParts.length < 2) {
            throw new IllegalArgumentException("Invalid upload token");
        }
        return new DataRecordUploadToken(decodedParts[0], decodedParts.length > 2 ? decodedParts[2] : null);
    }

    public String getEncodedToken(@NotNull byte[] secret) {
        String now = Instant.now().toString();
        String toBeEncoded = this.uploadId.isPresent() ? String.join((CharSequence)"#", this.blobId, now, this.uploadId.get()) : String.join((CharSequence)"#", this.blobId, now);
        String toBeSigned = DataRecordUploadToken.encodeBase64(toBeEncoded);
        String sig = DataRecordUploadToken.getSignedString(toBeSigned, secret);
        return sig != null ? toBeSigned + "#" + sig : toBeSigned;
    }

    private static String getSignedString(String toBeSigned, byte[] secret) {
        try {
            String algorithm = "HmacSHA1";
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(secret, "HmacSHA1"));
            byte[] hash = mac.doFinal(toBeSigned.getBytes(StandardCharsets.UTF_8));
            return DataRecordUploadToken.encodeBase64(hash);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            LOG.warn("Could not sign upload token", (Throwable)e);
            return null;
        }
    }

    private static String encodeBase64(String string) {
        return Base64.encodeBase64String((byte[])string.getBytes(StandardCharsets.UTF_8));
    }

    private static String encodeBase64(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    private static String decodeBase64(String encodedString) {
        return new String(Base64.decodeBase64((String)encodedString), StandardCharsets.UTF_8);
    }

    public String getBlobId() {
        return this.blobId;
    }

    public Optional<String> getUploadId() {
        return this.uploadId;
    }
}

