/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.util.concurrent.atomic.AtomicReference;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.sling.engine.impl.request.RequestData;
import org.apache.sling.engine.jmx.RequestProcessorMBean;
import org.osgi.service.component.annotations.Component;

@Component(service={RequestProcessorMBean.class, RequestProcessorMBeanImpl.class}, property={"jmx.objectname=org.apache.sling:type=engine,service=RequestProcessor"})
public class RequestProcessorMBeanImpl
extends StandardMBean
implements RequestProcessorMBean {
    private final AtomicReference<Data> dataRef = new AtomicReference<Data>(new Data());

    public RequestProcessorMBeanImpl() throws NotCompliantMBeanException {
        super(RequestProcessorMBean.class);
    }

    void addRequestData(RequestData data) {
        Data newVal;
        Data oldVal;
        boolean success;
        while (!(success = this.dataRef.compareAndSet(oldVal = this.dataRef.get(), newVal = new Data(oldVal, data)))) {
        }
    }

    @Override
    public void resetStatistics() {
        this.dataRef.set(new Data());
    }

    @Override
    public long getRequestsCount() {
        return this.dataRef.get().n;
    }

    @Override
    public long getMinRequestDurationMsec() {
        return this.dataRef.get().durationMsecMin;
    }

    @Override
    public long getMaxRequestDurationMsec() {
        return this.dataRef.get().durationMsecMax;
    }

    @Override
    public double getStandardDeviationDurationMsec() {
        return this.dataRef.get().standardDeviationDurationMsec;
    }

    @Override
    public double getMeanRequestDurationMsec() {
        return this.dataRef.get().meanRequestDurationMsec;
    }

    @Override
    public int getMaxPeakRecursionDepth() {
        return this.dataRef.get().peakRecursionDepthMax;
    }

    @Override
    public int getMinPeakRecursionDepth() {
        return this.dataRef.get().peakRecursionDepthMin;
    }

    @Override
    public double getMeanPeakRecursionDepth() {
        return this.dataRef.get().meanPeakRecursionDepth;
    }

    @Override
    public double getStandardDeviationPeakRecursionDepth() {
        return this.dataRef.get().standardDeviationPeakRecursionDepth;
    }

    @Override
    public int getMaxServletCallCount() {
        return this.dataRef.get().servletCallCountMax;
    }

    @Override
    public int getMinServletCallCount() {
        return this.dataRef.get().servletCallCountMin;
    }

    @Override
    public double getMeanServletCallCount() {
        return this.dataRef.get().meanServletCallCount;
    }

    @Override
    public double getStandardDeviationServletCallCount() {
        return this.dataRef.get().standardDeviationServletCallCount;
    }

    private static class Data {
        private final long n;
        private final long durationMsecMin;
        private final long durationMsecMax;
        private final double durationMsecSumX;
        private final double durationMsecSumX2;
        private final int servletCallCountMin;
        private final int servletCallCountMax;
        private final double servletCallCountSumX;
        private final double servletCallCountSumX2;
        private final int peakRecursionDepthMin;
        private final int peakRecursionDepthMax;
        private final double peakRecursionDepthSumX;
        private final double peakRecursionDepthSumX2;
        private final double standardDeviationDurationMsec;
        private final double meanRequestDurationMsec;
        private final double meanPeakRecursionDepth;
        private final double standardDeviationPeakRecursionDepth;
        private final double meanServletCallCount;
        private final double standardDeviationServletCallCount;

        Data() {
            this.n = 0L;
            this.durationMsecMin = Long.MAX_VALUE;
            this.durationMsecMax = 0L;
            this.durationMsecSumX = 0.0;
            this.durationMsecSumX2 = 0.0;
            this.servletCallCountMin = Integer.MAX_VALUE;
            this.servletCallCountMax = 0;
            this.servletCallCountSumX = 0.0;
            this.servletCallCountSumX2 = 0.0;
            this.peakRecursionDepthMin = Integer.MAX_VALUE;
            this.peakRecursionDepthMax = 0;
            this.peakRecursionDepthSumX = 0.0;
            this.peakRecursionDepthSumX2 = 0.0;
            this.standardDeviationDurationMsec = this.computeStandardDeviationDurationMsec();
            this.meanRequestDurationMsec = this.computeMeanRequestDurationMsec();
            this.meanPeakRecursionDepth = this.computeMeanPeakRecursionDepth();
            this.standardDeviationPeakRecursionDepth = this.computeStandardDeviationPeakRecursionDepth();
            this.meanServletCallCount = this.computeMeanServletCallCount();
            this.standardDeviationServletCallCount = this.computeStandardDeviationServletCallCount();
        }

        Data(Data other, RequestData data) {
            if (other == null || data == null) {
                throw new IllegalArgumentException("Neither 'other' nor 'data' may be null");
            }
            long duration = data.getElapsedTimeMsec();
            int servletCallCount = data.getServletCallCount();
            int peakRecursionDepth = data.getPeakRecusionDepth();
            this.n = other.n + 1L;
            this.durationMsecMin = Math.min(duration, other.durationMsecMin);
            this.durationMsecMax = Math.max(duration, other.durationMsecMax);
            this.durationMsecSumX = other.durationMsecSumX + (double)duration;
            this.durationMsecSumX2 = other.durationMsecSumX2 + (double)(duration * duration);
            this.servletCallCountMin = Math.min(servletCallCount, other.servletCallCountMin);
            this.servletCallCountMax = Math.max(servletCallCount, other.servletCallCountMax);
            this.servletCallCountSumX = other.servletCallCountSumX + (double)servletCallCount;
            this.servletCallCountSumX2 = other.servletCallCountSumX2 + (double)(servletCallCount * servletCallCount);
            this.peakRecursionDepthMin = Math.min(peakRecursionDepth, other.peakRecursionDepthMin);
            this.peakRecursionDepthMax = Math.max(peakRecursionDepth, other.peakRecursionDepthMax);
            this.peakRecursionDepthSumX = other.peakRecursionDepthSumX + (double)peakRecursionDepth;
            this.peakRecursionDepthSumX2 = other.peakRecursionDepthSumX2 + (double)(peakRecursionDepth * peakRecursionDepth);
            this.standardDeviationDurationMsec = this.computeStandardDeviationDurationMsec();
            this.meanRequestDurationMsec = this.computeMeanRequestDurationMsec();
            this.meanPeakRecursionDepth = this.computeMeanPeakRecursionDepth();
            this.standardDeviationPeakRecursionDepth = this.computeStandardDeviationPeakRecursionDepth();
            this.meanServletCallCount = this.computeMeanServletCallCount();
            this.standardDeviationServletCallCount = this.computeStandardDeviationServletCallCount();
        }

        private double computeStandardDeviationDurationMsec() {
            if (this.n > 1L) {
                return Math.sqrt((this.durationMsecSumX2 - this.durationMsecSumX * this.durationMsecSumX / (double)this.n) / (double)(this.n - 1L));
            }
            return 0.0;
        }

        private double computeMeanRequestDurationMsec() {
            if (this.n > 0L) {
                return this.durationMsecSumX / (double)this.n;
            }
            return 0.0;
        }

        private double computeMeanPeakRecursionDepth() {
            if (this.n > 0L) {
                return this.peakRecursionDepthSumX / (double)this.n;
            }
            return 0.0;
        }

        private double computeStandardDeviationPeakRecursionDepth() {
            if (this.n > 1L) {
                return Math.sqrt((this.peakRecursionDepthSumX2 - this.peakRecursionDepthSumX * this.peakRecursionDepthSumX / (double)this.n) / (double)(this.n - 1L));
            }
            return 0.0;
        }

        private double computeMeanServletCallCount() {
            if (this.n > 0L) {
                return this.servletCallCountSumX / (double)this.n;
            }
            return 0.0;
        }

        private double computeStandardDeviationServletCallCount() {
            if (this.n > 1L) {
                return Math.sqrt((this.servletCallCountSumX2 - this.servletCallCountSumX * this.servletCallCountSumX / (double)this.n) / (double)(this.n - 1L));
            }
            return 0.0;
        }
    }
}

