/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.transaction;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.spring.transaction.SpringTXPluginConfig;
import org.apache.skywalking.apm.plugin.spring.transaction.context.Constants;
import org.springframework.transaction.TransactionDefinition;

public class GetTransactionMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (allArguments[0] == null) {
            AbstractSpan span = ContextManager.createLocalSpan((String)"TX/get/noTransactionDefinitionGiven");
            span.setComponent((Component)ComponentsDefine.SPRING_TX);
            return;
        }
        TransactionDefinition definition = (TransactionDefinition)allArguments[0];
        AbstractSpan span = ContextManager.createLocalSpan((String)("TX/get/" + this.buildOperationName(definition.getName())));
        span.tag(Constants.TAG_SPRING_TRANSACTION_ISOLATION_LEVEL, String.valueOf(definition.getIsolationLevel()));
        span.tag(Constants.TAG_SPRING_TRANSACTION_PROPAGATION_BEHAVIOR, String.valueOf(definition.getPropagationBehavior()));
        span.tag(Constants.TAG_SPRING_TRANSACTION_TIMEOUT, String.valueOf(definition.getTimeout()));
        span.setComponent((Component)ComponentsDefine.SPRING_TX);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private String buildOperationName(String transactionDefinitionName) {
        if (!SpringTXPluginConfig.Plugin.SpringTransaction.SIMPLIFY_TRANSACTION_DEFINITION_NAME) {
            return transactionDefinitionName;
        }
        String[] ss = transactionDefinitionName.split("\\.");
        int simplifiedLength = ss.length - 2;
        if (simplifiedLength < 0) {
            return transactionDefinitionName;
        }
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < ss.length - 1; ++i) {
            name.append(i < simplifiedLength ? Character.valueOf(ss[i].charAt(0)) : ss[i]).append(".");
        }
        return name.append(ss[ss.length - 1]).toString();
    }
}

