/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.storage.DataStores;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

final class MimeTypeCommand
extends CommandRunner {
    MimeTypeCommand(int commandIndex, Object[] arguments) throws InvalidOptionException {
        super(commandIndex, arguments, EnumSet.of(Option.ENCODING, Option.HELP, Option.DEBUG));
    }

    @Override
    public int run() throws Exception {
        if (this.hasUnexpectedFileCount(1, Integer.MAX_VALUE)) {
            return 3;
        }
        String[] names = (String[])this.files.stream().map(IOUtilities::toString).toArray(String[]::new);
        int width = Arrays.stream(names).mapToInt(String::length).max().orElse(0) + 1;
        for (int i = 0; i < names.length; ++i) {
            String type;
            URI uri;
            Object file = this.files.get(i);
            try {
                uri = IOUtilities.toURI(file);
            }
            catch (URISyntaxException e) {
                this.canNotOpen(0, e);
                return 100;
            }
            if (uri == null || !uri.isAbsolute()) {
                type = DataStores.probeContentType(file);
            } else {
                try {
                    type = Files.probeContentType(Path.of(uri));
                }
                catch (IllegalArgumentException | FileSystemNotFoundException e) {
                    type = DataStores.probeContentType((Object)uri);
                }
                catch (NoSuchFileException e) {
                    this.error(Errors.format((short)14, (Object)uri), e);
                    return 100;
                }
            }
            if (type == null) continue;
            String name = names[i];
            this.out.print(name);
            this.out.print(':');
            this.out.print(CharSequences.spaces((int)(width - name.length())));
            this.out.println(type);
            this.out.flush();
        }
        return 0;
    }
}

