/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.jts;

import java.io.Serializable;
import org.apache.sis.geometry.wrapper.jts.PackedCoordinateSequence;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Coordinates;

final class PackedCoordinateSequenceFactory
implements CoordinateSequenceFactory,
Serializable {
    private static final long serialVersionUID = 8160800176640629524L;
    protected final boolean doublePrecision;

    PackedCoordinateSequenceFactory(boolean doublePrecision) {
        this.doublePrecision = doublePrecision;
    }

    public CoordinateSequence create(Coordinate[] coordinates) {
        int dimension = 3;
        int measures = 0;
        int size = 0;
        boolean first = true;
        if (coordinates != null) {
            size = coordinates.length;
            for (Coordinate c : coordinates) {
                int m = Coordinates.measures((Coordinate)c);
                dimension = Math.min(dimension, Coordinates.dimension((Coordinate)c) - m);
                if (!(first | m < measures)) continue;
                measures = m;
                first = false;
            }
        }
        PackedCoordinateSequence cs = this.create(size, dimension += measures, measures);
        if (size != 0) {
            cs.setCoordinates(coordinates);
        }
        return cs;
    }

    public CoordinateSequence create(CoordinateSequence original) {
        int size;
        int measures;
        int dimension;
        if (original instanceof PackedCoordinateSequence) {
            return original.copy();
        }
        if (original != null) {
            dimension = original.getDimension();
            measures = original.getMeasures();
            size = original.size();
        } else {
            dimension = 3;
            measures = 0;
            size = 0;
        }
        PackedCoordinateSequence cs = this.create(size, dimension, measures);
        if (size != 0) {
            cs.setCoordinates(original);
        }
        return cs;
    }

    public CoordinateSequence create(int size, int dimension) {
        return this.create(size, dimension, 0);
    }

    public PackedCoordinateSequence create(int size, int dimension, int measures) {
        if (this.doublePrecision) {
            return new PackedCoordinateSequence.Double(size, dimension, measures);
        }
        return new PackedCoordinateSequence.Float(size, dimension, measures);
    }
}

