/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gml;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlValue;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.pending.geoapi.temporal.Instant;
import org.apache.sis.xml.bind.gml.TimeInstant;

@XmlTransient
public abstract class TimePeriodBound {
    TimePeriodBound() {
    }

    abstract XMLGregorianCalendar calendar();

    public String toString() {
        return String.valueOf(this.calendar());
    }

    public static final class GML2
    extends TimePeriodBound {
        @XmlElement(name="TimeInstant")
        public TimeInstant timeInstant;

        public GML2() {
        }

        GML2(Instant instant) {
            this.timeInstant = new TimeInstant(instant != null ? instant.getPosition() : null);
        }

        @Override
        XMLGregorianCalendar calendar() {
            TimeInstant timeInstant = this.timeInstant;
            return timeInstant != null ? timeInstant.timePosition : null;
        }
    }

    public static final class GML3
    extends TimePeriodBound {
        @XmlAttribute
        public String indeterminatePosition;
        @XmlValue
        public XMLGregorianCalendar value;

        public GML3() {
        }

        GML3(Instant instant, String indeterminate) {
            if (instant != null) {
                this.value = TimeInstant.toXML(instant.getPosition());
                if (this.value == null) {
                    instant.getIndeterminatePosition().ifPresent(p -> {
                        this.indeterminatePosition = p.identifier();
                    });
                }
            }
            if (this.value == null && this.indeterminatePosition == null) {
                this.indeterminatePosition = indeterminate;
            }
        }

        @Override
        XMLGregorianCalendar calendar() {
            return this.value;
        }
    }
}

