/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.opengis.metadata.Metadata;
import org.opengis.util.GenericName;

public interface Resource {
    public Optional<GenericName> getIdentifier() throws DataStoreException;

    public Metadata getMetadata() throws DataStoreException;

    default public Optional<FileSet> getFileSet() throws DataStoreException {
        return Optional.empty();
    }

    public <T extends StoreEvent> void addListener(Class<T> var1, StoreListener<? super T> var2);

    public <T extends StoreEvent> void removeListener(Class<T> var1, StoreListener<? super T> var2);

    public static class FileSet {
        private final Collection<Path> paths;

        public FileSet(Path path) {
            this.paths = List.of(path);
        }

        public FileSet(Path[] paths) {
            this.paths = List.of(paths);
        }

        public FileSet(Collection<Path> paths) {
            this.paths = List.copyOf(paths);
        }

        public Collection<Path> getPaths() {
            return this.paths;
        }

        private Path getBaseDirectory() {
            Path directory = null;
            for (Path path : this.getPaths()) {
                path = path.getParent();
                if (directory != null && !directory.startsWith(path)) continue;
                directory = path;
            }
            return directory;
        }

        public Path copy(Path destDir) throws IOException {
            HashSet<Path> subdirs = new HashSet<Path>();
            Path base = this.getBaseDirectory();
            Path main = null;
            Iterator<Path> iterator = this.getPaths().iterator();
            while (iterator.hasNext()) {
                Path source;
                Path target = source = iterator.next();
                if (base != null) {
                    target = base.relativize(target);
                    FileSet.mkdirs(destDir, target, subdirs);
                }
                target = Files.copy(source, destDir.resolve(target), new CopyOption[0]);
                if (main != null) continue;
                main = target;
            }
            return main;
        }

        private static void mkdirs(Path destDir, Path file, Set<Path> done) throws IOException {
            if ((file = file.getParent()) != null && done.add(file)) {
                FileSet.mkdirs(destDir, file, done);
                Files.createDirectory(destDir.resolve(file), new FileAttribute[0]);
            }
        }

        public void delete() throws IOException {
            Path base = null;
            boolean first = true;
            for (Path path : this.getPaths()) {
                if (first) {
                    first = false;
                    base = path.getParent();
                } else if (base != null && !path.startsWith(base)) continue;
                Files.delete(path);
            }
        }
    }
}

