/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.joinJudgement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sedona.core.enums.DistanceMetric;
import org.apache.sedona.core.joinJudgement.KnnJoinIndexJudgement;
import org.apache.sedona.core.wrapper.UniqueGeometry;
import org.apache.spark.util.LongAccumulator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.strtree.ItemDistance;
import org.locationtech.jts.index.strtree.STRtree;

public class InMemoryKNNJoinIterator<T extends Geometry, U extends Geometry>
implements Iterator<Pair<T, U>> {
    private final Iterator<T> querySideIterator;
    private final STRtree strTree;
    private final int k;
    private final DistanceMetric distanceMetric;
    private final boolean includeTies;
    private final ItemDistance itemDistance;
    private final LongAccumulator streamCount;
    private final LongAccumulator resultCount;
    private final List<Pair<T, U>> currentResults = new ArrayList<Pair<T, U>>();
    private int currentResultIndex = 0;

    public InMemoryKNNJoinIterator(Iterator<T> querySideIterator, STRtree strTree, int k, DistanceMetric distanceMetric, boolean includeTies, LongAccumulator streamCount, LongAccumulator resultCount) {
        this.querySideIterator = querySideIterator;
        this.strTree = strTree;
        this.k = k;
        this.distanceMetric = distanceMetric;
        this.includeTies = includeTies;
        this.itemDistance = KnnJoinIndexJudgement.getItemDistance(distanceMetric);
        this.streamCount = streamCount;
        this.resultCount = resultCount;
    }

    @Override
    public boolean hasNext() {
        if (this.currentResultIndex < this.currentResults.size()) {
            return true;
        }
        this.currentResultIndex = 0;
        this.currentResults.clear();
        while (this.querySideIterator.hasNext()) {
            this.populateNextBatch();
            if (this.currentResults.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Pair<T, U> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentResults.get(this.currentResultIndex++);
    }

    private void populateNextBatch() {
        Geometry queryItem = (Geometry)this.querySideIterator.next();
        Geometry queryGeom = queryItem instanceof UniqueGeometry ? (Geometry)((UniqueGeometry)queryItem).getOriginalGeometry() : queryItem;
        this.streamCount.add(1L);
        Object[] localK = this.strTree.nearestNeighbour(queryGeom.getEnvelopeInternal(), queryGeom, this.itemDistance, this.k);
        if (this.includeTies) {
            localK = this.getUpdatedLocalKWithTies(queryGeom, localK, this.strTree);
        }
        for (Object obj : localK) {
            Geometry candidate = (Geometry)obj;
            Pair pair = Pair.of((Object)queryItem, (Object)candidate);
            this.currentResults.add(pair);
            this.resultCount.add(1L);
        }
    }

    private Object[] getUpdatedLocalKWithTies(Geometry streamShape, Object[] localK, STRtree strTree) {
        Envelope searchEnvelope = streamShape.getEnvelopeInternal();
        double maxDistance = 0.0;
        LinkedHashSet<Geometry> uniqueCandidates = new LinkedHashSet<Geometry>();
        for (Object obj : localK) {
            Geometry candidate = (Geometry)obj;
            uniqueCandidates.add(candidate);
            double distance = streamShape.distance(candidate);
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
        }
        searchEnvelope.expandBy(maxDistance);
        List candidates = strTree.query(searchEnvelope);
        if (!candidates.isEmpty()) {
            ArrayList<Geometry> tiedResults = new ArrayList<Geometry>();
            Collections.addAll(tiedResults, localK);
            for (Geometry candidate : candidates) {
                double distance = streamShape.distance(candidate);
                if (distance != maxDistance || uniqueCandidates.contains(candidate)) continue;
                tiedResults.add(candidate);
            }
            localK = tiedResults.toArray();
        }
        return localK;
    }
}

