/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2Loop;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Polygon;
import com.google.common.geometry.S2Polyline;
import com.google.common.geometry.S2Region;
import com.google.common.geometry.S2RegionCoverer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class S2Utils {
    public static S2Point toS2Point(Coordinate coord) {
        return S2LatLng.fromDegrees(coord.y, coord.x).toPoint();
    }

    public static List<S2Point> toS2Points(Coordinate[] coords) {
        return Arrays.stream(coords).map(S2Utils::toS2Point).collect(Collectors.toList());
    }

    public static S2Polyline toS2PolyLine(LineString line) {
        return new S2Polyline(S2Utils.toS2Points(line.getCoordinates()));
    }

    public static S2Loop toS2Loop(LinearRing ring) {
        return new S2Loop(Orientation.isCCW(ring.getCoordinates()) ? S2Utils.toS2Points(ring.getCoordinates()) : S2Utils.toS2Points(ring.reverse().getCoordinates()));
    }

    public static S2Polygon toS2Polygon(Polygon polygon) {
        ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
        rings.add(polygon.getExteriorRing());
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            rings.add(polygon.getInteriorRingN(i));
        }
        List<S2Loop> s2Loops = rings.stream().map(S2Utils::toS2Loop).collect(Collectors.toList());
        return new S2Polygon(s2Loops);
    }

    public static List<S2CellId> s2RegionToCellIDs(S2Region region, int minLevel, int maxLevel, int maxNum) {
        S2RegionCoverer.Builder coverBuilder = S2RegionCoverer.builder();
        coverBuilder.setMinLevel(minLevel);
        coverBuilder.setMaxLevel(maxLevel);
        coverBuilder.setMaxCells(maxNum);
        return coverBuilder.build().getCovering(region).cellIds();
    }

    public static S2CellId coordinateToCellID(Coordinate coordinate, int level) {
        return S2CellId.fromPoint(S2Utils.toS2Point(coordinate)).parent(level);
    }

    public static List<S2CellId> roundCellsToSameLevel(List<S2CellId> cellIDs, int level) {
        HashSet<Long> results = new HashSet<Long>();
        for (S2CellId cellID : cellIDs) {
            if (cellID.level() > level) {
                results.add(cellID.parent(level).id());
                continue;
            }
            if (cellID.level() < level) {
                S2CellId c = cellID.childBegin(level);
                while (!c.equals(cellID.childEnd(level))) {
                    results.add(c.id());
                    c = c.next();
                }
                continue;
            }
            results.add(cellID.id());
        }
        return results.stream().map(S2CellId::new).collect(Collectors.toList());
    }

    public static Polygon toJTSPolygon(S2CellId cellId) {
        S2LatLngRect bound = new S2Cell(cellId).getRectBound();
        Coordinate[] coords = new Coordinate[5];
        int[] iters = new int[]{0, 1, 2, 3, 0};
        for (int i = 0; i < 5; ++i) {
            coords[i] = new Coordinate(bound.getVertex(iters[i]).lngDegrees(), bound.getVertex(iters[i]).latDegrees());
        }
        return new GeometryFactory().createPolygon(coords);
    }

    public static S2Region toS2Region(Geometry geom) throws IllegalArgumentException {
        if (geom instanceof Polygon) {
            return S2Utils.toS2Polygon((Polygon)geom);
        }
        if (geom instanceof LineString) {
            return S2Utils.toS2PolyLine((LineString)geom);
        }
        throw new IllegalArgumentException("only object of Polygon, LinearRing, LineString type can be converted to S2Region");
    }
}

