/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.CDMNode;
import ucar.nc2.Dimension;
import ucar.nc2.Dimensions;
import ucar.nc2.EnumTypedef;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Variable;
import ucar.nc2.util.EscapeStrings;
import ucar.nc2.util.Indent;

public class Group
extends CDMNode
implements AttributeContainer {
    protected NetcdfFile ncfile;
    protected List<Variable> variables = new ArrayList<Variable>();
    protected List<Dimension> dimensions = new ArrayList<Dimension>();
    protected List<Group> groups = new ArrayList<Group>();
    protected AttributeContainer attributes;
    protected List<EnumTypedef> enumTypedefs = new ArrayList<EnumTypedef>();
    private int hashCode;

    @Deprecated
    static List<Group> collectPath(Group g2) {
        ArrayList<Group> list = new ArrayList<Group>();
        while (g2 != null) {
            list.add(0, g2);
            g2 = g2.getParentGroup();
        }
        return list;
    }

    public boolean isRoot() {
        return this.getParentGroup() == null;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    @Deprecated
    @Nullable
    public Variable findVariable(String varShortName) {
        return this.findVariableLocal(varShortName);
    }

    @Nullable
    public Variable findVariableLocal(String varShortName) {
        if (varShortName == null) {
            return null;
        }
        for (Variable v : this.variables) {
            if (!varShortName.equals(v.getShortName())) continue;
            return v;
        }
        return null;
    }

    @Nullable
    public Variable findVariableOrInParent(String varShortName) {
        if (varShortName == null) {
            return null;
        }
        Variable v = this.findVariableLocal(varShortName);
        Group parent = this.getParentGroup();
        if (v == null && parent != null) {
            v = parent.findVariableOrInParent(varShortName);
        }
        return v;
    }

    @Nullable
    public Variable findVariableByAttribute(String attName, String attValue) {
        for (Variable v : this.getVariables()) {
            for (Attribute att : v.attributes()) {
                if (!attName.equals(att.getShortName()) || !attValue.equals(att.getStringValue())) continue;
                return v;
            }
        }
        for (Group nested : this.getGroups()) {
            Variable v = nested.findVariableByAttribute(attName, attValue);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Override
    @Nullable
    public Group getParentGroup() {
        return this.group;
    }

    @Override
    public String getFullName() {
        return NetcdfFiles.makeFullName(this);
    }

    public ImmutableList<Group> getGroups() {
        return ImmutableList.copyOf(this.groups);
    }

    public NetcdfFile getNetcdfFile() {
        return this.ncfile;
    }

    @Nullable
    public Group findGroupLocal(String groupShortName) {
        if (groupShortName == null) {
            return null;
        }
        for (Group group : this.groups) {
            if (!groupShortName.equals(group.getShortName())) continue;
            return group;
        }
        return null;
    }

    @Deprecated
    public Group findGroup(String groupShortName) {
        return this.findGroupLocal(groupShortName);
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public ImmutableList<Dimension> makeDimensionsList(String dimString) throws IllegalArgumentException {
        return Dimensions.makeDimensionsList(this::findDimension, dimString);
    }

    public ImmutableList<EnumTypedef> getEnumTypedefs() {
        return ImmutableList.copyOf(this.enumTypedefs);
    }

    @Nullable
    public Dimension findDimension(String name) {
        if (name == null) {
            return null;
        }
        Dimension d = this.findDimensionLocal(name);
        if (d != null) {
            return d;
        }
        Group parent = this.getParentGroup();
        if (parent != null) {
            return parent.findDimension(name);
        }
        return null;
    }

    @Nullable
    public Dimension findDimension(Dimension dim) {
        if (dim == null) {
            return null;
        }
        for (Dimension d : this.dimensions) {
            if (!d.equals(dim)) continue;
            return d;
        }
        Group parent = this.getParentGroup();
        if (parent != null) {
            return parent.findDimension(dim);
        }
        return null;
    }

    @Nullable
    public Dimension findDimensionLocal(String shortName) {
        if (shortName == null) {
            return null;
        }
        for (Dimension d : this.dimensions) {
            if (!shortName.equals(d.getShortName())) continue;
            return d;
        }
        return null;
    }

    public AttributeContainer attributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    public Attribute findAttribute(String name) {
        return this.attributes.findAttribute(name);
    }

    @Override
    public String findAttributeString(String attName, String defaultValue) {
        return this.attributes.findAttributeString(attName, defaultValue);
    }

    @Override
    @Deprecated
    public List<Attribute> getAttributes() {
        return AttributeContainer.filter(this.attributes, Attribute.SPECIALS).getAttributes();
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    @Deprecated
    public Attribute findAttributeIgnoreCase(String name) {
        return this.attributes.findAttributeIgnoreCase(name);
    }

    @Override
    @Deprecated
    public double findAttributeDouble(String attName, double defaultValue) {
        return this.attributes.findAttributeDouble(attName, defaultValue);
    }

    @Override
    @Deprecated
    public int findAttributeInteger(String attName, int defaultValue) {
        return this.attributes.findAttributeInteger(attName, defaultValue);
    }

    @Override
    @Deprecated
    public Attribute addAttribute(Attribute att) {
        return this.attributes.addAttribute(att);
    }

    @Override
    @Deprecated
    public void addAll(Iterable<Attribute> atts) {
        this.attributes.addAll(atts);
    }

    @Override
    @Deprecated
    public boolean remove(Attribute a) {
        return this.attributes.remove(a);
    }

    @Override
    @Deprecated
    public boolean removeAttribute(String attName) {
        return this.attributes.removeAttribute(attName);
    }

    @Override
    @Deprecated
    public boolean removeAttributeIgnoreCase(String attName) {
        return this.attributes.removeAttributeIgnoreCase(attName);
    }

    @Nullable
    public EnumTypedef findEnumeration(String name) {
        if (name == null) {
            return null;
        }
        for (EnumTypedef d : this.enumTypedefs) {
            if (!name.equals(d.getShortName())) continue;
            return d;
        }
        Group parent = this.getParentGroup();
        if (parent != null) {
            return parent.findEnumeration(name);
        }
        return null;
    }

    public Group commonParent(Group other) {
        if (this.isParent(other)) {
            return this;
        }
        if (other.isParent(this)) {
            return other;
        }
        while (!other.isParent(this)) {
            other = other.getParentGroup();
        }
        return other;
    }

    public boolean isParent(Group other) {
        while (other != this && other.getParentGroup() != null) {
            other = other.getParentGroup();
        }
        return other == this;
    }

    public String getNameAndAttributes() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Group ");
        sbuff.append(this.getShortName());
        sbuff.append("\n");
        for (Attribute att : this.attributes) {
            sbuff.append("  ").append(this.getShortName()).append(":");
            sbuff.append(att);
            sbuff.append(";");
            sbuff.append("\n");
        }
        return sbuff.toString();
    }

    @Deprecated
    public String writeCDL(boolean strict) {
        Formatter buf = new Formatter();
        this.writeCDL(buf, new Indent(2), strict);
        return buf.toString();
    }

    @Deprecated
    void writeCDL(Formatter out, Indent indent, boolean strict) {
        boolean hasA;
        boolean hasE = !this.enumTypedefs.isEmpty();
        boolean hasD = !this.dimensions.isEmpty();
        boolean hasV = !this.variables.isEmpty();
        boolean bl = hasA = !Iterables.isEmpty(this.attributes);
        if (hasE) {
            out.format("%stypes:%n", indent);
            indent.incr();
            for (EnumTypedef e : this.enumTypedefs) {
                e.writeCDL(out, indent, strict);
                out.format("%n", new Object[0]);
            }
            indent.decr();
            out.format("%n", new Object[0]);
        }
        if (hasD) {
            out.format("%sdimensions:%n", indent);
            indent.incr();
            for (Dimension myd : this.dimensions) {
                myd.writeCDL(out, indent, strict);
                out.format("%n", new Object[0]);
            }
            indent.decr();
        }
        if (hasV) {
            out.format("%svariables:%n", indent);
            indent.incr();
            for (Variable v : this.variables) {
                v.writeCDL(out, indent, false, strict);
                out.format("%n", new Object[0]);
            }
            indent.decr();
        }
        for (Group g2 : this.groups) {
            String gname = strict ? NetcdfFiles.makeValidCDLName(g2.getShortName()) : g2.getShortName();
            out.format("%sgroup: %s {%n", indent, gname);
            indent.incr();
            g2.writeCDL(out, indent, strict);
            indent.decr();
            out.format("%s}%n%n", indent);
        }
        if (hasA) {
            if (this.isRoot()) {
                out.format("%s// global attributes:%n", indent);
            } else {
                out.format("%s// group attributes:%n", indent);
            }
            for (Attribute att : this.attributes) {
                if (Attribute.isspecial(att)) continue;
                out.format("%s", indent);
                att.writeCDL(out, strict, null);
                out.format(";", new Object[0]);
                if (!strict && att.getDataType() != DataType.STRING) {
                    out.format(" // %s", new Object[]{att.getDataType()});
                }
                out.format("%n", new Object[0]);
            }
        }
    }

    @Deprecated
    public Group(NetcdfFile ncfile, Group parent, String shortName) {
        super(shortName);
        this.ncfile = ncfile;
        this.attributes = new AttributeContainerMutable(shortName);
        this.setParentGroup(parent == null ? ncfile.getRootGroup() : parent);
    }

    @Override
    @Deprecated
    public void setParentGroup(Group parent) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        super.setParentGroup(parent == null ? this.ncfile.getRootGroup() : parent);
    }

    @Deprecated
    public String setName(String shortName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.setShortName(shortName);
        return this.getShortName();
    }

    @Deprecated
    public void addDimension(Dimension dim) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (!dim.isShared()) {
            throw new IllegalArgumentException("Dimensions added to a group must be shared.");
        }
        if (this.findDimensionLocal(dim.getShortName()) != null) {
            throw new IllegalArgumentException("Dimension name (" + dim.getShortName() + ") must be unique within Group " + this.getShortName());
        }
        this.dimensions.add(dim);
        dim.setGroup(this);
    }

    @Deprecated
    public boolean addDimensionIfNotExists(Dimension dim) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (!dim.isShared()) {
            throw new IllegalArgumentException("Dimensions added to a group must be shared.");
        }
        if (this.findDimensionLocal(dim.getShortName()) != null) {
            return false;
        }
        this.dimensions.add(dim);
        dim.setGroup(this);
        return true;
    }

    @Deprecated
    public void addGroup(Group g2) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (this.findGroupLocal(g2.getShortName()) != null) {
            throw new IllegalArgumentException("Group name (" + g2.getShortName() + ") must be unique within Group " + this.getShortName());
        }
        this.groups.add(g2);
        g2.setParentGroup(this);
    }

    @Deprecated
    public void addEnumeration(EnumTypedef e) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (e == null) {
            return;
        }
        e.setParentGroup(this);
        this.enumTypedefs.add(e);
    }

    @Deprecated
    public void addVariable(Variable v) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (v == null) {
            return;
        }
        if (this.findVariableLocal(v.getShortName()) != null) {
            throw new IllegalArgumentException("Variable name (" + v.getShortName() + ") must be unique within Group " + this.getShortName());
        }
        this.variables.add(v);
        v.setParentGroup(this);
    }

    @Deprecated
    public boolean remove(Dimension d) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return d != null && this.dimensions.remove(d);
    }

    @Deprecated
    public boolean remove(Group g2) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return g2 != null && this.groups.remove(g2);
    }

    @Deprecated
    public boolean remove(Variable v) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return v != null && this.variables.remove(v);
    }

    @Deprecated
    public boolean removeDimension(String dimName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension d = this.dimensions.get(i);
            if (!dimName.equals(d.getShortName())) continue;
            this.dimensions.remove(d);
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean removeVariable(String shortName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable v = this.variables.get(i);
            if (!shortName.equals(v.getShortName())) continue;
            this.variables.remove(v);
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public Group setImmutable() {
        super.setImmutable();
        this.variables = Collections.unmodifiableList(this.variables);
        this.dimensions = Collections.unmodifiableList(this.dimensions);
        this.groups = Collections.unmodifiableList(this.groups);
        return this;
    }

    public String toString() {
        return this.writeCDL(false);
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Group)) {
            return false;
        }
        Group og = (Group)oo;
        if (!this.getShortName().equals(og.getShortName())) {
            return false;
        }
        return this.getParentGroup() == null || this.getParentGroup().equals(og.getParentGroup());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getShortName().hashCode();
            if (this.getParentGroup() != null) {
                result = 37 * result + this.getParentGroup().hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    @Deprecated
    public Group makeRelativeGroup(NetcdfFile ncf, String path, boolean ignorelast) {
        boolean isabsolute;
        path = path.trim();
        boolean bl = isabsolute = (path = path.replace("//", "/")).charAt(0) == '/';
        if (isabsolute) {
            path = path.substring(1);
        }
        String[] pieces = path.split("/");
        if (ignorelast) {
            pieces[pieces.length - 1] = null;
        }
        Group current = isabsolute ? this.ncfile.getRootGroup() : this;
        for (String name : pieces) {
            if (name == null) continue;
            String clearname = NetcdfFile.makeNameUnescaped(name);
            Group next = current.findGroupLocal(clearname);
            if (next == null) {
                next = new Group(ncf, current, clearname);
                current.addGroup(next);
            }
            current = next;
        }
        return current;
    }

    private Group(Builder builder, @Nullable Group parent) {
        super(builder.shortName);
        this.group = parent;
        this.ncfile = builder.ncfile;
        builder.dimensions.forEach(d -> d.setGroup(this));
        this.dimensions = new ArrayList<Dimension>(builder.dimensions);
        this.enumTypedefs = new ArrayList<EnumTypedef>(builder.enumTypedefs);
        this.groups = builder.gbuilders.stream().map(g2 -> g2.setNcfile(this.ncfile).build(this)).collect(Collectors.toList());
        builder.vbuilders.forEach(vb -> {
            if (vb.ncfile == null) {
                vb.setNcfile(this.ncfile);
            }
        });
        for (Variable.Builder<?> vb2 : builder.vbuilders) {
            Variable var = vb2.build(this);
            this.variables.add(var);
        }
        this.attributes = builder.attributes;
        this.dimensions.forEach(d -> d.setParentGroup(this));
        this.enumTypedefs.forEach(e -> e.setParentGroup(this));
    }

    public Builder toBuilder() {
        Builder builder = Group.builder().setName(this.shortName).setNcfile(this.ncfile).addAttributes(this.attributes).addDimensions(this.dimensions).addEnumTypedefs(this.enumTypedefs);
        this.groups.forEach(g2 -> builder.addGroup(g2.toBuilder()));
        this.variables.forEach(v -> builder.addVariable(v.toBuilder()));
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final Logger logger = LoggerFactory.getLogger(Builder.class);
        @Nullable
        private Builder parentGroup;
        public List<Builder> gbuilders = new ArrayList<Builder>();
        public List<Variable.Builder<?>> vbuilders = new ArrayList();
        public String shortName = "";
        private NetcdfFile ncfile;
        private AttributeContainerMutable attributes = new AttributeContainerMutable("");
        private List<Dimension> dimensions = new ArrayList<Dimension>();
        public List<EnumTypedef> enumTypedefs = new ArrayList<EnumTypedef>();
        private boolean built;

        public Builder setParentGroup(@Nullable Builder parentGroup) {
            this.parentGroup = parentGroup;
            return this;
        }

        @Nullable
        public Builder getParentGroup() {
            return this.parentGroup;
        }

        public Builder addAttribute(Attribute att) {
            Preconditions.checkNotNull(att);
            this.attributes.addAttribute(att);
            return this;
        }

        public Builder addAttributes(Iterable<Attribute> atts) {
            Preconditions.checkNotNull(atts);
            this.attributes.addAll(atts);
            return this;
        }

        public AttributeContainerMutable getAttributeContainer() {
            return this.attributes;
        }

        public Builder addDimension(Dimension dim) {
            Preconditions.checkNotNull(dim);
            this.findDimensionLocal(dim.shortName).ifPresent(d -> {
                throw new IllegalArgumentException("Dimension '" + d.shortName + "' already exists");
            });
            this.dimensions.add(dim);
            return this;
        }

        public boolean addDimensionIfNotExists(Dimension dim) {
            Preconditions.checkNotNull(dim);
            if (!this.findDimensionLocal(dim.shortName).isPresent()) {
                this.dimensions.add(dim);
                return true;
            }
            return false;
        }

        public Builder addDimensions(Collection<Dimension> dims) {
            Preconditions.checkNotNull(dims);
            dims.forEach(this::addDimension);
            return this;
        }

        public boolean replaceDimension(Dimension dim) {
            Optional<Dimension> want = this.findDimensionLocal(dim.shortName);
            want.ifPresent(d -> this.dimensions.remove(d));
            this.addDimension(dim);
            return want.isPresent();
        }

        public boolean removeDimension(String name) {
            Optional<Dimension> want = this.findDimensionLocal(name);
            want.ifPresent(d -> this.dimensions.remove(d));
            return want.isPresent();
        }

        public Optional<Dimension> findDimensionLocal(String name) {
            return this.dimensions.stream().filter(d -> d.shortName.equals(name)).findFirst();
        }

        public boolean contains(Dimension want) {
            Dimension have = this.dimensions.stream().filter(d -> d.equals(want)).findFirst().orElse(null);
            if (have != null) {
                return true;
            }
            if (this.parentGroup != null) {
                return this.parentGroup.contains(want);
            }
            return false;
        }

        public Optional<Dimension> findDimension(String name) {
            if (name == null) {
                return Optional.empty();
            }
            Optional<Dimension> dopt = this.findDimensionLocal(name);
            if (dopt.isPresent()) {
                return dopt;
            }
            if (this.parentGroup != null) {
                return this.parentGroup.findDimension(name);
            }
            return Optional.empty();
        }

        public Iterable<Dimension> getDimensions() {
            return this.dimensions;
        }

        public Builder addGroup(Builder nested) {
            Preconditions.checkNotNull(nested);
            this.findGroupLocal(nested.shortName).ifPresent(g2 -> {
                throw new IllegalStateException("Nested group already exists " + nested.shortName);
            });
            this.gbuilders.add(nested);
            nested.setParentGroup(this);
            return this;
        }

        public Builder addGroups(Collection<Builder> groups) {
            Preconditions.checkNotNull(groups);
            groups.addAll(groups);
            return this;
        }

        public boolean removeGroup(String name) {
            Optional<Builder> want = this.findGroupLocal(name);
            want.ifPresent(v -> this.gbuilders.remove(v));
            return want.isPresent();
        }

        public Optional<Builder> findGroupLocal(String shortName) {
            return this.gbuilders.stream().filter(g2 -> g2.shortName.equals(shortName)).findFirst();
        }

        public Optional<Builder> findGroupNested(String reletiveName) {
            if (reletiveName == null || reletiveName.isEmpty()) {
                return this.getParentGroup() == null ? Optional.of(this) : Optional.empty();
            }
            Builder g2 = this;
            StringTokenizer stoke = new StringTokenizer(reletiveName, "/");
            while (stoke.hasMoreTokens()) {
                String groupName = NetcdfFiles.makeNameUnescaped(stoke.nextToken());
                Optional<Builder> sub = g2.findGroupLocal(groupName);
                if (!sub.isPresent()) {
                    return Optional.empty();
                }
                g2 = sub.get();
            }
            return Optional.of(g2);
        }

        public boolean isParent(Builder other) {
            while (other != this && other.parentGroup != null) {
                other = other.parentGroup;
            }
            return other == this;
        }

        public Builder commonParent(Builder other) {
            if (this.isParent(other)) {
                return this;
            }
            if (other.isParent(this)) {
                return other;
            }
            while (!other.isParent(this)) {
                other = other.parentGroup;
            }
            return other;
        }

        public Builder addEnumTypedef(EnumTypedef typedef) {
            Preconditions.checkNotNull(typedef);
            this.enumTypedefs.add(typedef);
            return this;
        }

        public Builder addEnumTypedefs(Collection<EnumTypedef> typedefs) {
            Preconditions.checkNotNull(typedefs);
            this.enumTypedefs.addAll(typedefs);
            return this;
        }

        public EnumTypedef findOrAddEnumTypedef(String name, Map<Integer, String> map) {
            Optional<EnumTypedef> opt = this.findEnumTypedef(name);
            if (opt.isPresent()) {
                return opt.get();
            }
            EnumTypedef enumTypedef = new EnumTypedef(name, map);
            this.addEnumTypedef(enumTypedef);
            return enumTypedef;
        }

        public Optional<EnumTypedef> findEnumTypedef(String name) {
            return this.enumTypedefs.stream().filter(e -> e.shortName.equals(name)).findFirst();
        }

        public Builder addVariable(Variable.Builder<?> variable) {
            Preconditions.checkNotNull(variable);
            this.findVariableLocal(variable.shortName).ifPresent(v -> {
                throw new IllegalArgumentException("Variable '" + v.shortName + "' already exists");
            });
            this.vbuilders.add(variable);
            variable.setParentGroupBuilder(this);
            return this;
        }

        public Builder addVariables(Collection<Variable.Builder<?>> vars) {
            vars.forEach(this::addVariable);
            return this;
        }

        public boolean replaceVariable(Variable.Builder<?> vb) {
            Optional<Variable.Builder<?>> want = this.findVariableLocal(vb.shortName);
            want.ifPresent(v -> this.vbuilders.remove(v));
            this.addVariable(vb);
            return want.isPresent();
        }

        public boolean removeVariable(String name) {
            Optional<Variable.Builder<?>> want = this.findVariableLocal(name);
            want.ifPresent(v -> this.vbuilders.remove(v));
            return want.isPresent();
        }

        public Optional<Variable.Builder<?>> findVariableLocal(String name) {
            return this.vbuilders.stream().filter(v -> v.shortName.equals(name)).findFirst();
        }

        public Optional<Variable.Builder<?>> findVariableNested(String reletiveName) {
            if (reletiveName == null || reletiveName.isEmpty()) {
                return Optional.empty();
            }
            Builder group = this;
            String varName = reletiveName;
            int pos = reletiveName.lastIndexOf(47);
            if (pos >= 0) {
                String groupNames = reletiveName.substring(0, pos);
                varName = reletiveName.substring(pos + 1);
                group = this.findGroupNested(groupNames).orElse(null);
            }
            return group == null ? Optional.empty() : group.findVariableLocal(varName);
        }

        public Optional<Variable.Builder<?>> findVariableOrInParent(String varShortName) {
            if (varShortName == null) {
                return Optional.empty();
            }
            Optional<Variable.Builder<?>> vopt = this.findVariableLocal(varShortName);
            Builder parent = this.getParentGroup();
            if (!vopt.isPresent() && parent != null) {
                vopt = parent.findVariableOrInParent(varShortName);
            }
            return vopt;
        }

        public Builder setNcfile(NetcdfFile ncfile) {
            this.ncfile = ncfile;
            return this;
        }

        public Builder setName(String shortName) {
            this.shortName = NetcdfFiles.makeValidCdmObjectName(shortName);
            return this;
        }

        @Deprecated
        public NetcdfFile getNcfile() {
            return this.ncfile;
        }

        public ImmutableList<Dimension> makeDimensionsList(String dimString) throws IllegalArgumentException {
            return Dimensions.makeDimensionsList(dimName -> this.findDimension(dimName).orElse(null), dimString);
        }

        public String makeFullName() {
            if (this.parentGroup == null) {
                return "";
            }
            StringBuilder sbuff = new StringBuilder();
            this.appendGroupName(sbuff, this);
            return sbuff.toString();
        }

        private void appendGroupName(StringBuilder sbuff, Builder g2) {
            if (g2 == null || g2.getParentGroup() == null) {
                return;
            }
            this.appendGroupName(sbuff, g2.getParentGroup());
            sbuff.append(EscapeStrings.backslashEscape(g2.shortName, ".\\"));
            sbuff.append("/");
        }

        public void removeDimensionFromAllGroups(Builder group, Dimension remove) {
            group.dimensions.removeIf(dim -> dim.equals(remove));
            group.gbuilders.forEach(g2 -> this.removeDimensionFromAllGroups((Builder)g2, remove));
        }

        public void makeDimensionMap(Builder parent, Multimap<Dimension, Variable.Builder<?>> dimUsedMap) {
            for (Variable.Builder<?> v : parent.vbuilders) {
                for (Dimension d : this.getDimensionsFor(parent, v)) {
                    if (!d.isShared()) continue;
                    dimUsedMap.put(d, v);
                }
            }
            for (Builder g2 : parent.gbuilders) {
                this.makeDimensionMap(g2, dimUsedMap);
            }
        }

        private List<Dimension> getDimensionsFor(Builder gb, Variable.Builder<?> vb) {
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            for (Dimension dim : vb.getDimensions()) {
                if (dim.isShared()) {
                    Dimension sharedDim = gb.findDimension(dim.getShortName()).orElse(null);
                    if (sharedDim == null) {
                        throw new IllegalStateException(String.format("Shared Dimension %s does not exist in a parent proup", dim));
                    }
                    dims.add(sharedDim);
                    continue;
                }
                dims.add(dim);
            }
            return dims;
        }

        public Group build() {
            return this.build(null);
        }

        Group build(@Nullable Group parent) {
            if (this.built) {
                throw new IllegalStateException("Group was already built " + this.shortName);
            }
            this.built = true;
            return new Group(this, parent);
        }
    }
}

