/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.coverage;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.io.WKTWriter;

class CoverageEdge {
    public static final int RING_COUNT_INNER = 2;
    public static final int RING_COUNT_OUTER = 1;
    private Coordinate[] pts;
    private int ringCount = 0;
    private boolean isFreeRing = true;
    private boolean isPrimary = true;
    private int adjacentIndex0 = -1;
    private int adjacentIndex1 = -1;

    public static CoverageEdge createEdge(Coordinate[] ring, boolean isPrimary) {
        Coordinate[] pts = CoverageEdge.extractEdgePoints(ring, 0, ring.length - 1);
        CoverageEdge edge = new CoverageEdge(pts, isPrimary, true);
        return edge;
    }

    public static CoverageEdge createEdge(Coordinate[] ring, int start, int end, boolean isPrimary) {
        Coordinate[] pts = CoverageEdge.extractEdgePoints(ring, start, end);
        CoverageEdge edge = new CoverageEdge(pts, isPrimary, false);
        return edge;
    }

    private static Coordinate[] extractEdgePoints(Coordinate[] ring, int start, int end) {
        int size = start < end ? end - start + 1 : ring.length - start + end;
        Coordinate[] pts = new Coordinate[size];
        int iring = start;
        for (int i = 0; i < size; ++i) {
            pts[i] = ring[iring].copy();
            if (++iring < ring.length) continue;
            iring = 1;
        }
        return pts;
    }

    public static LineSegment key(Coordinate[] ring) {
        Coordinate adj1;
        int indexLow = 0;
        for (int i = 1; i < ring.length - 1; ++i) {
            if (ring[indexLow].compareTo(ring[i]) >= 0) continue;
            indexLow = i;
        }
        Coordinate key0 = ring[indexLow];
        Coordinate adj0 = CoverageEdge.findDistinctPoint(ring, indexLow, true, key0);
        Coordinate key1 = adj0.compareTo(adj1 = CoverageEdge.findDistinctPoint(ring, indexLow, false, key0)) < 0 ? adj0 : adj1;
        return new LineSegment(key0, key1);
    }

    public static LineSegment key(Coordinate[] ring, int start, int end) {
        Coordinate key1;
        Coordinate key0;
        boolean isForward;
        Coordinate end0 = ring[start];
        Coordinate end1 = ring[end];
        boolean bl = isForward = 0 > end0.compareTo(end1);
        if (isForward) {
            key0 = end0;
            key1 = CoverageEdge.findDistinctPoint(ring, start, true, key0);
        } else {
            key0 = end1;
            key1 = CoverageEdge.findDistinctPoint(ring, end, false, key0);
        }
        return new LineSegment(key0, key1);
    }

    private static Coordinate findDistinctPoint(Coordinate[] pts, int index, boolean isForward, Coordinate pt) {
        int inc = isForward ? 1 : -1;
        int i = index;
        do {
            if (!pts[i].equals2D(pt)) {
                return pts[i];
            }
            if ((i += inc) < 0) {
                i = pts.length - 1;
                continue;
            }
            if (i <= pts.length - 1) continue;
            i = 0;
        } while (i != index);
        throw new IllegalStateException("Edge does not contain distinct points");
    }

    public CoverageEdge(Coordinate[] pts, boolean isPrimary, boolean isFreeRing) {
        this.pts = pts;
        this.isPrimary = isPrimary;
        this.isFreeRing = isFreeRing;
    }

    public void incRingCount() {
        ++this.ringCount;
    }

    public int getRingCount() {
        return this.ringCount;
    }

    public boolean isInner() {
        return this.ringCount == 2;
    }

    public boolean isOuter() {
        return this.ringCount == 1;
    }

    public void setPrimary(boolean isPrimary) {
        if (this.isPrimary) {
            return;
        }
        this.isPrimary = isPrimary;
    }

    public boolean isRemovableRing() {
        boolean isRing = CoordinateArrays.isRing(this.pts);
        return isRing && !this.isPrimary;
    }

    public boolean isFreeRing() {
        return this.isFreeRing;
    }

    public void setCoordinates(Coordinate[] pts) {
        this.pts = pts;
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public Coordinate getEndCoordinate() {
        return this.pts[this.pts.length - 1];
    }

    public Coordinate getStartCoordinate() {
        return this.pts[0];
    }

    public LineString toLineString(GeometryFactory geomFactory) {
        return geomFactory.createLineString(this.getCoordinates());
    }

    public String toString() {
        return WKTWriter.toLineString(this.pts);
    }

    public void addIndex(int index) {
        if (this.adjacentIndex0 < 0) {
            this.adjacentIndex0 = index;
        } else {
            this.adjacentIndex1 = index;
        }
    }

    public int getAdjacentIndex(int index) {
        if (index == 0) {
            return this.adjacentIndex0;
        }
        return this.adjacentIndex1;
    }

    public boolean hasAdjacentIndex(int index) {
        if (index == 0) {
            return this.adjacentIndex0 >= 0;
        }
        return this.adjacentIndex1 >= 0;
    }
}

