/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.stac;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.Serializable;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.sedona_sql.io.stac.StacTable$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

public final class StacUtils$ {
    public static StacUtils$ MODULE$;

    static {
        new StacUtils$();
    }

    public String loadStacCollectionToJson(scala.collection.immutable.Map<String, String> opts) {
        String urlFull = this.getFullCollectionUrl(opts);
        return this.loadStacCollectionToJson(urlFull, this.loadStacCollectionToJson$default$2());
    }

    /*
     * WARNING - void declaration
     */
    public String getFullCollectionUrl(scala.collection.immutable.Map<String, String> opts) {
        void var3_3;
        String url = (String)opts.getOrElse((Object)"path", (Function0 & Serializable & scala.Serializable)() -> (String)opts.getOrElse((Object)"service", (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Either 'path' or 'service' must be provided");
        }));
        String urlFinal = url.matches("^[a-zA-Z][a-zA-Z0-9+.-]*://.*") ? url : new StringBuilder(7).append("file://").append(url).toString();
        return var3_3;
    }

    public String loadStacCollectionToJson(String url, int maxRetries) {
        int retries = 0;
        boolean success = false;
        String result = "";
        while (retries < maxRetries && !success) {
            try {
                result = url.startsWith("s3://") || url.startsWith("s3a://") ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SparkSession$.MODULE$.active().read().textFile(url).collect())).mkString("\n") : Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                success = true;
            }
            catch (Exception e) {
                if (++retries < maxRetries) continue;
                throw new RuntimeException(new StringBuilder(52).append("Failed to load STAC collection from ").append(url).append(" after ").append(maxRetries).append(" attempts").toString(), e);
            }
        }
        return result;
    }

    public int loadStacCollectionToJson$default$2() {
        return 3;
    }

    public String getStacCollectionBasePath(scala.collection.immutable.Map<String, String> opts) {
        String ref = (String)opts.getOrElse((Object)"path", (Function0 & Serializable & scala.Serializable)() -> (String)opts.getOrElse((Object)"service", (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Either 'path' or 'service' must be provided");
        }));
        return this.getStacCollectionBasePath(ref);
    }

    public String getStacCollectionBasePath(String collectionUrl) {
        String string;
        Regex urlPattern = new StringOps(Predef$.MODULE$.augmentString("(https?://[^/]+/|http://[^/]+/).*")).r();
        Regex filePattern = new StringOps(Predef$.MODULE$.augmentString("(file:///.*/|/.*/).*")).r();
        String string2 = collectionUrl;
        Option option = urlPattern.unapplySeq((CharSequence)string2);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String baseUrl;
            string = baseUrl = (String)((LinearSeqOptimized)option.get()).apply(0);
        } else {
            Option option2 = filePattern.unapplySeq((CharSequence)string2);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                String basePath = (String)((LinearSeqOptimized)option2.get()).apply(0);
                string = basePath.startsWith("file://") ? basePath : new StringBuilder(7).append("file://").append(basePath).toString();
            } else {
                throw new IllegalArgumentException(new StringBuilder(26).append("Invalid URL or file path: ").append(collectionUrl).toString());
            }
        }
        return string;
    }

    public StructType inferStacSchema(scala.collection.immutable.Map<String, String> opts) {
        StructType structType;
        String stacVersion;
        String stacCollectionJsonString = this.loadStacCollectionToJson(opts);
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        JsonNode collection = mapper.readTree(stacCollectionJsonString);
        String string = stacVersion = collection.get("stac_version").asText();
        if ("1.0.0".equals(string)) {
            structType = StacTable$.MODULE$.SCHEMA_V1_0_0();
        } else if (string.matches("1\\.[1-9]\\d*\\.\\d*")) {
            structType = StacTable$.MODULE$.SCHEMA_V1_1_0();
        } else {
            throw new IllegalArgumentException(new StringBuilder(26).append("Unsupported STAC version: ").append(stacVersion).toString());
        }
        return structType;
    }

    public InternalRow promotePropertiesToTop(InternalRow row, StructType schema) {
        int propertiesIndex = schema.fieldIndex("properties");
        StructType propertiesStruct = (StructType)schema.apply("properties").dataType();
        InternalRow propertiesRow = row.getStruct(propertiesIndex, propertiesStruct.fields().length);
        Seq newValues = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Seq acc = (Seq)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    StructField field = (StructField)tuple22._1();
                    String string = field.name();
                    String string2 = "properties";
                    if (string == null) {
                        if (string2 == null) return (Seq)acc.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])propertiesStruct.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            StructField propField = (StructField)tuple2._1();
                            int propIndex = tuple2._2$mcI$sp();
                            Object object = propertiesRow.get(propIndex, propField.dataType());
                            return object;
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object())))), Seq$.MODULE$.canBuildFrom());
                    } else if (string.equals(string2)) {
                        return (Seq)acc.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])propertiesStruct.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            StructField propField = (StructField)tuple2._1();
                            int propIndex = tuple2._2$mcI$sp();
                            Object object = propertiesRow.get(propIndex, propField.dataType());
                            return object;
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object())))), Seq$.MODULE$.canBuildFrom());
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Seq acc = (Seq)tuple2._1();
            Tuple2 tuple23 = (Tuple2)tuple2._2();
            if (tuple23 == null) throw new MatchError((Object)tuple2);
            int index = tuple23._2$mcI$sp();
            return (Seq)acc.$colon$plus(row.get(index, schema.apply(index).dataType()), Seq$.MODULE$.canBuildFrom());
        });
        return InternalRow$.MODULE$.fromSeq(newValues);
    }

    public StructType updatePropertiesPromotedSchema(StructType schema) {
        int propertiesIndex = schema.fieldIndex("properties");
        StructType propertiesStruct = (StructType)schema.apply("properties").dataType();
        Seq newFields = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                String string;
                Seq acc = (Seq)tuple2._1();
                StructField structField = (StructField)tuple2._2();
                if (structField != null && "properties".equals(string = structField.name())) {
                    return (Seq)acc.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])propertiesStruct.fields())), Seq$.MODULE$.canBuildFrom());
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Seq acc = (Seq)tuple2._1();
            StructField other = (StructField)tuple2._2();
            return (Seq)acc.$colon$plus((Object)other, Seq$.MODULE$.canBuildFrom());
        });
        return StructType$.MODULE$.apply(newFields);
    }

    public InternalRow buildOutDbRasterFields(InternalRow row, StructType schema) {
        Object[] newValues = new Object[schema.fields().length];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StacUtils$.$anonfun$buildOutDbRasterFields$1(row, newValues, schema, x0$1);
            return BoxedUnit.UNIT;
        });
        return InternalRow$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)newValues));
    }

    public int getNumPartitions(int itemCount, int numPartitions, int maxPartitionItemFiles, int defaultParallelism) {
        int n;
        if (numPartitions > 0) {
            n = numPartitions;
        } else {
            int maxSplitFiles = maxPartitionItemFiles > 0 ? Math.min(maxPartitionItemFiles, (int)Math.ceil((double)itemCount / (double)defaultParallelism)) : (int)Math.ceil((double)itemCount / (double)defaultParallelism);
            n = Math.max(1, (int)Math.ceil((double)itemCount / (double)maxSplitFiles));
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$buildOutDbRasterFields$1(InternalRow row$2, Object[] newValues$1, StructType schema$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField structField = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (structField != null) {
                String string = structField.name();
                DataType dataType = structField.dataType();
                if ("assets".equals(string) && dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType dataType2 = mapType.keyType();
                    DataType valueType = mapType.valueType();
                    if (StringType$.MODULE$.equals(dataType2) && valueType instanceof StructType) {
                        BoxedUnit boxedUnit;
                        MapData assetsMap = row$2.getMap(index);
                        if (assetsMap != null) {
                            scala.collection.immutable.Map updatedAssets = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)assetsMap.keyArray().array()).zip((GenIterable)Predef$.MODULE$.genericWrapArray((Object)assetsMap.valueArray().array()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                Tuple2 tuple2 = x0$2;
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                Object key = tuple2._1();
                                Object value = tuple2._2();
                                InternalRow assetRow = (InternalRow)value;
                                Tuple2 tuple22 = assetRow != null ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)assetRow) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), null);
                                return tuple22;
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                            newValues$1[index] = ArrayBasedMapData$.MODULE$.apply((Map)updatedAssets, ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            newValues$1[index] = null;
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int index = tuple2._2$mcI$sp();
        newValues$1[index] = row$2.get(index, schema$2.fields()[index].dataType());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private StacUtils$() {
        MODULE$ = this;
    }
}

