/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.spider;

import java.util.Random;
import org.apache.sedona.common.spider.PointBasedGenerator;
import org.locationtech.jts.geom.Coordinate;

public class SierpinskiGenerator
extends PointBasedGenerator {
    private final Coordinate point1 = new Coordinate(0.0, 0.0);
    private final Coordinate point2 = new Coordinate(1.0, 0.0);
    private final Coordinate point3 = new Coordinate(0.5, Math.sqrt(3.0) / 2.0);
    private Coordinate prevPoint;
    private long iRecord = 0L;

    public SierpinskiGenerator(Random random, PointBasedGenerator.PointBasedParameter pointBasedParameter) {
        super(random, pointBasedParameter);
    }

    @Override
    protected Coordinate generateCoordinate() {
        Coordinate point;
        if (this.iRecord == 0L) {
            point = this.point1;
        } else if (this.iRecord == 1L) {
            point = this.point2;
        } else if (this.iRecord == 2L) {
            point = this.point3;
        } else {
            int roll = this.dice(5);
            Coordinate targetPoint = roll <= 2 ? this.point1 : (roll <= 4 ? this.point2 : this.point3);
            point = this.middlePoint(this.prevPoint, targetPoint);
        }
        ++this.iRecord;
        this.prevPoint = point;
        return point;
    }

    private Coordinate middlePoint(Coordinate p1, Coordinate p2) {
        double x = (p1.x + p2.x) / 2.0;
        double y = (p1.y + p2.y) / 2.0;
        return new Coordinate(x, y);
    }
}

