/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.seatunnel.connectors.seatunnel.file.s3.source.config;

import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseFileSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileSystemType;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.s3.config.S3HadoopConf;

import lombok.Getter;

@Getter
public class S3FileSourceConfig extends BaseFileSourceConfig {

    private static final long serialVersionUID = 1L;

    @Override
    public HadoopConf getHadoopConfig() {
        return S3HadoopConf.buildWithReadOnlyConfig(getBaseFileSourceConfig());
    }

    @Override
    public String getPluginName() {
        return FileSystemType.S3.getFileSystemPluginName();
    }

    public S3FileSourceConfig(ReadonlyConfig readonlyConfig) {
        super(readonlyConfig);
    }
}
