////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////
package org.apache.royale.mdl.supportClasses
{
    import org.apache.royale.core.ILabelFieldItemRenderer;
    import org.apache.royale.core.IIndexedItemRenderer;

    /**
     *  The ITabItemRenderer interface is the basic interface for MDL Tabs and TabBar item renderers.
     *
     *  @langversion 3.0
     *  @playerversion Flash 10.2
     *  @playerversion AIR 2.6
     *  @productversion Royale 0.8
     */
    public interface ITabItemRenderer extends ILabelFieldItemRenderer, IIndexedItemRenderer
    {
        /**
         *  Provides name of the property which stores "id" for Tab
         *
         *  @langversion 3.0
         *  @playerversion Flash 10.2
         *  @playerversion AIR 2.6
         *  @productversion Royale 0.8
         */
        function get tabIdField():String;
        function set tabIdField(value:String):void;

        /**
         *  Indicates whether specific Tab is currently selected/active
         * 
         *  @langversion 3.0
         *  @playerversion Flash 10.2
         *  @playerversion AIR 2.6
         *  @productversion Royale 0.8
         */
        function get isActive():Boolean;
        function set isActive(value:Boolean):void;
    }
}
