/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.graphrbac.GraphErrorException;
import com.microsoft.azure.management.graphrbac.implementation.AADObjectInner;
import com.microsoft.azure.management.graphrbac.implementation.GetObjectsParametersInner;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManagementClientImpl;
import com.microsoft.azure.management.graphrbac.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ObjectsInner {
    private ObjectsService service;
    private GraphRbacManagementClientImpl client;

    public ObjectsInner(Retrofit retrofit, GraphRbacManagementClientImpl client) {
        this.service = (ObjectsService)retrofit.create(ObjectsService.class);
        this.client = client;
    }

    public AADObjectInner getCurrentUser() {
        return (AADObjectInner)((ServiceResponse)this.getCurrentUserWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<AADObjectInner> getCurrentUserAsync(ServiceCallback<AADObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCurrentUserWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<AADObjectInner> getCurrentUserAsync() {
        return this.getCurrentUserWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<AADObjectInner>, AADObjectInner>(){

            public AADObjectInner call(ServiceResponse<AADObjectInner> response) {
                return (AADObjectInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AADObjectInner>> getCurrentUserWithServiceResponseAsync() {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getCurrentUser(this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AADObjectInner>>>(){

            public Observable<ServiceResponse<AADObjectInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ObjectsInner.this.getCurrentUserDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AADObjectInner> getCurrentUserDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AADObjectInner>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public PagedList<AADObjectInner> getObjectsByObjectIds(GetObjectsParametersInner parameters) {
        ServiceResponse response = (ServiceResponse)this.getObjectsByObjectIdsSinglePageAsync(parameters).toBlocking().single();
        return new PagedList<AADObjectInner>((Page)response.body()){

            public Page<AADObjectInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)ObjectsInner.this.getObjectsByObjectIdsNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AADObjectInner>> getObjectsByObjectIdsAsync(GetObjectsParametersInner parameters, ListOperationCallback<AADObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getObjectsByObjectIdsSinglePageAsync(parameters), (Func1)new Func1<String, Observable<ServiceResponse<Page<AADObjectInner>>>>(){

            public Observable<ServiceResponse<Page<AADObjectInner>>> call(String nextLink) {
                return ObjectsInner.this.getObjectsByObjectIdsNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AADObjectInner>> getObjectsByObjectIdsAsync(GetObjectsParametersInner parameters) {
        return this.getObjectsByObjectIdsWithServiceResponseAsync(parameters).map((Func1)new Func1<ServiceResponse<Page<AADObjectInner>>, Page<AADObjectInner>>(){

            public Page<AADObjectInner> call(ServiceResponse<Page<AADObjectInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AADObjectInner>>> getObjectsByObjectIdsWithServiceResponseAsync(GetObjectsParametersInner parameters) {
        return this.getObjectsByObjectIdsSinglePageAsync(parameters).concatMap((Func1)new Func1<ServiceResponse<Page<AADObjectInner>>, Observable<ServiceResponse<Page<AADObjectInner>>>>(){

            public Observable<ServiceResponse<Page<AADObjectInner>>> call(ServiceResponse<Page<AADObjectInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ObjectsInner.this.getObjectsByObjectIdsNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AADObjectInner>>> getObjectsByObjectIdsSinglePageAsync(GetObjectsParametersInner parameters) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.getObjectsByObjectIds(this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AADObjectInner>>>>(){

            public Observable<ServiceResponse<Page<AADObjectInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ObjectsInner.this.getObjectsByObjectIdsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AADObjectInner>> getObjectsByObjectIdsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AADObjectInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AADObjectInner> getObjectsByObjectIdsNext(String nextLink) {
        ServiceResponse response = (ServiceResponse)this.getObjectsByObjectIdsNextSinglePageAsync(nextLink).toBlocking().single();
        return new PagedList<AADObjectInner>((Page)response.body()){

            public Page<AADObjectInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)ObjectsInner.this.getObjectsByObjectIdsNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AADObjectInner>> getObjectsByObjectIdsNextAsync(String nextLink, ServiceFuture<List<AADObjectInner>> serviceFuture, ListOperationCallback<AADObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getObjectsByObjectIdsNextSinglePageAsync(nextLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AADObjectInner>>>>(){

            public Observable<ServiceResponse<Page<AADObjectInner>>> call(String nextLink) {
                return ObjectsInner.this.getObjectsByObjectIdsNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AADObjectInner>> getObjectsByObjectIdsNextAsync(String nextLink) {
        return this.getObjectsByObjectIdsNextWithServiceResponseAsync(nextLink).map((Func1)new Func1<ServiceResponse<Page<AADObjectInner>>, Page<AADObjectInner>>(){

            public Page<AADObjectInner> call(ServiceResponse<Page<AADObjectInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AADObjectInner>>> getObjectsByObjectIdsNextWithServiceResponseAsync(String nextLink) {
        return this.getObjectsByObjectIdsNextSinglePageAsync(nextLink).concatMap((Func1)new Func1<ServiceResponse<Page<AADObjectInner>>, Observable<ServiceResponse<Page<AADObjectInner>>>>(){

            public Observable<ServiceResponse<Page<AADObjectInner>>> call(ServiceResponse<Page<AADObjectInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ObjectsInner.this.getObjectsByObjectIdsNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AADObjectInner>>> getObjectsByObjectIdsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            throw new IllegalArgumentException("Parameter nextLink is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String nextUrl = String.format("%s/%s", this.client.tenantID(), nextLink);
        return this.service.getObjectsByObjectIdsNext(nextUrl, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AADObjectInner>>>>(){

            public Observable<ServiceResponse<Page<AADObjectInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ObjectsInner.this.getObjectsByObjectIdsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AADObjectInner>> getObjectsByObjectIdsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AADObjectInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ObjectsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Objects getCurrentUser"})
        @GET(value="{tenantID}/me")
        public Observable<Response<ResponseBody>> getCurrentUser(@Path(value="tenantID") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Objects getObjectsByObjectIds"})
        @POST(value="{tenantID}/getObjectsByObjectIds")
        public Observable<Response<ResponseBody>> getObjectsByObjectIds(@Path(value="tenantID") String var1, @Body GetObjectsParametersInner var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Objects getObjectsByObjectIdsNext"})
        @GET
        public Observable<Response<ResponseBody>> getObjectsByObjectIdsNext(@Url String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

