/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.implementation.DeploymentOperationInner;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DeploymentOperationsInner {
    private DeploymentOperationsService service;
    private ResourceManagementClientImpl client;

    public DeploymentOperationsInner(Retrofit retrofit, ResourceManagementClientImpl client) {
        this.service = (DeploymentOperationsService)retrofit.create(DeploymentOperationsService.class);
        this.client = client;
    }

    public DeploymentOperationInner get(String resourceGroupName, String deploymentName, String operationId) {
        return (DeploymentOperationInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, deploymentName, operationId).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentOperationInner> getAsync(String resourceGroupName, String deploymentName, String operationId, ServiceCallback<DeploymentOperationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, deploymentName, operationId), serviceCallback);
    }

    public Observable<DeploymentOperationInner> getAsync(String resourceGroupName, String deploymentName, String operationId) {
        return this.getWithServiceResponseAsync(resourceGroupName, deploymentName, operationId).map((Func1)new Func1<ServiceResponse<DeploymentOperationInner>, DeploymentOperationInner>(){

            public DeploymentOperationInner call(ServiceResponse<DeploymentOperationInner> response) {
                return (DeploymentOperationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentOperationInner>> getWithServiceResponseAsync(String resourceGroupName, String deploymentName, String operationId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (operationId == null) {
            throw new IllegalArgumentException("Parameter operationId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, deploymentName, operationId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentOperationInner>>>(){

            public Observable<ServiceResponse<DeploymentOperationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentOperationsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentOperationInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentOperationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentOperationInner> listByResourceGroup(String resourceGroupName, String deploymentName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, deploymentName).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listByResourceGroupAsync(String resourceGroupName, String deploymentName, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, deploymentName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listByResourceGroupAsync(String resourceGroupName, String deploymentName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, deploymentName).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, String deploymentName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, deploymentName).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, String deploymentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer top = null;
        return this.service.listByResourceGroup(resourceGroupName, deploymentName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<DeploymentOperationInner> listByResourceGroup(String resourceGroupName, String deploymentName, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, deploymentName, top).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listByResourceGroupAsync(String resourceGroupName, String deploymentName, Integer top, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, deploymentName, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listByResourceGroupAsync(String resourceGroupName, String deploymentName, Integer top) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, deploymentName, top).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, String deploymentName, Integer top) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, deploymentName, top).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, String deploymentName, Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, deploymentName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentOperationInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentOperationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentOperationInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<DeploymentOperationInner>> serviceFuture, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentOperationInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentOperationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DeploymentOperationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations get"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/deployments/{deploymentName}/operations/{operationId}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="operationId") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/deployments/{deploymentName}/operations")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="subscriptionId") String var3, @Query(value="$top") Integer var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

