/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.dns.RecordType;
import com.microsoft.azure.management.dns.TxtRecord;
import com.microsoft.azure.management.dns.TxtRecordSet;
import com.microsoft.azure.management.dns.implementation.DnsRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneImpl;
import com.microsoft.azure.management.dns.implementation.RecordSetInner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@LangDefinition
class TxtRecordSetImpl
extends DnsRecordSetImpl
implements TxtRecordSet {
    TxtRecordSetImpl(String name, DnsZoneImpl parent, RecordSetInner innerModel) {
        super(name, RecordType.TXT.toString(), parent, innerModel);
    }

    static TxtRecordSetImpl newRecordSet(String name, DnsZoneImpl parent) {
        return new TxtRecordSetImpl(name, parent, new RecordSetInner().withTxtRecords(new ArrayList<TxtRecord>()));
    }

    @Override
    public List<TxtRecord> records() {
        if (((RecordSetInner)this.inner()).txtRecords() != null) {
            return Collections.unmodifiableList(((RecordSetInner)this.inner()).txtRecords());
        }
        return Collections.unmodifiableList(new ArrayList());
    }

    @Override
    protected RecordSetInner prepareForUpdate(RecordSetInner resource) {
        if (((RecordSetInner)this.inner()).txtRecords() != null && ((RecordSetInner)this.inner()).txtRecords().size() > 0) {
            if (resource.txtRecords() == null) {
                resource.withTxtRecords(new ArrayList<TxtRecord>());
            }
            resource.txtRecords().addAll(((RecordSetInner)this.inner()).txtRecords());
            ((RecordSetInner)this.inner()).txtRecords().clear();
        }
        if (this.recordSetRemoveInfo.txtRecords().size() > 0) {
            if (resource.txtRecords() != null) {
                block0: for (TxtRecord recordToRemove : this.recordSetRemoveInfo.txtRecords()) {
                    for (TxtRecord record : resource.txtRecords()) {
                        boolean exists = record.value().equals(recordToRemove.value());
                        if (!exists) continue;
                        resource.txtRecords().remove(record);
                        continue block0;
                    }
                }
            }
            this.recordSetRemoveInfo.txtRecords().clear();
        }
        return resource;
    }
}

