/*
 * Decompiled with CFR 0.152.
 */
package com.scurrilous.circe;

import com.scurrilous.circe.HashParameters;
import com.scurrilous.circe.HashProviders;
import com.scurrilous.circe.HashSupport;
import com.scurrilous.circe.IncrementalIntHash;
import com.scurrilous.circe.IncrementalLongHash;
import com.scurrilous.circe.StatefulHash;
import com.scurrilous.circe.StatelessIntHash;
import com.scurrilous.circe.StatelessLongHash;
import java.util.EnumSet;

public final class Hashes {
    private Hashes() {
    }

    public static StatefulHash createStateful(HashParameters params) {
        return HashProviders.best(params).createStateful(params);
    }

    public static StatelessIntHash getStatelessInt(HashParameters params) {
        return HashProviders.best(params, EnumSet.of(HashSupport.INT_SIZED)).getStatelessInt(params);
    }

    public static StatelessLongHash getStatelessLong(HashParameters params) {
        return HashProviders.best(params, EnumSet.of(HashSupport.LONG_SIZED)).getStatelessLong(params);
    }

    public static IncrementalIntHash getIncrementalInt(HashParameters params) {
        return HashProviders.best(params, EnumSet.of(HashSupport.INT_SIZED, HashSupport.STATELESS_INCREMENTAL)).getIncrementalInt(params);
    }

    public static IncrementalLongHash getIncrementalLong(HashParameters params) {
        return HashProviders.best(params, EnumSet.of(HashSupport.LONG_SIZED, HashSupport.STATELESS_INCREMENTAL)).getIncrementalLong(params);
    }
}

