/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.schema;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.pulsar.client.api.EncodeData;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class KeyValue<K, V> {
    private final K key;
    private final V value;

    public KeyValue(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyValue)) {
            return false;
        }
        KeyValue another = (KeyValue)obj;
        return Objects.equals(this.key, another.key) && Objects.equals(this.value, another.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(key = \"").append(this.key).append("\", value = \"").append(this.value).append("\")");
        return sb.toString();
    }

    public static <K, V> byte[] encode(K key, Schema<K> keyWriter, V value, Schema<V> valueWriter) {
        return KeyValue.encode(null, key, keyWriter, value, valueWriter).data();
    }

    public static <K, V> EncodeData encode(String topic, K key, Schema<K> keyWriter, V value, Schema<V> valueWriter) {
        EncodeData keyEncodeData = key == null ? new EncodeData(new byte[0]) : keyWriter.encode(topic, key);
        EncodeData valueEncodeData = value == null ? new EncodeData(new byte[0]) : valueWriter.encode(topic, value);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + keyEncodeData.data().length + 4 + valueEncodeData.data().length);
        byteBuffer.putInt(key == null ? -1 : keyEncodeData.data().length).put(keyEncodeData.data()).putInt(value == null ? -1 : valueEncodeData.data().length).put(valueEncodeData.data());
        return new EncodeData(byteBuffer.array(), KeyValue.generateKVSchemaId(keyEncodeData.schemaId(), valueEncodeData.schemaId()));
    }

    public static byte[] generateKVSchemaId(byte[] keySchemaId, byte[] valueSchemaId) {
        if (!EncodeData.isValidSchemaId(keySchemaId) && !EncodeData.isValidSchemaId(valueSchemaId)) {
            return null;
        }
        keySchemaId = keySchemaId == null ? new byte[]{} : keySchemaId;
        valueSchemaId = valueSchemaId == null ? new byte[]{} : valueSchemaId;
        ByteBuffer buffer = ByteBuffer.allocate(4 + keySchemaId.length + 4 + valueSchemaId.length);
        buffer.putInt(keySchemaId.length).put(keySchemaId).putInt(valueSchemaId.length).put(valueSchemaId);
        return buffer.array();
    }

    public static KeyValue<byte[], byte[]> getSchemaId(byte[] schemaId) {
        ByteBuffer buffer = ByteBuffer.wrap(schemaId);
        int keySchemaLength = buffer.getInt();
        byte[] keySchemaId = new byte[]{};
        if (keySchemaLength > 0) {
            keySchemaId = new byte[keySchemaLength];
            buffer.get(keySchemaId);
        }
        int valueSchemaLength = buffer.getInt();
        byte[] valueSchemaId = new byte[]{};
        if (valueSchemaLength > 0) {
            valueSchemaId = new byte[valueSchemaLength];
            buffer.get(valueSchemaId);
        }
        return new KeyValue<byte[], byte[]>(keySchemaId, valueSchemaId);
    }

    public static <K, V> KeyValue<K, V> decode(byte[] data, KeyValueDecoder<K, V> decoder) {
        int valueLength;
        byte[] valueBytes;
        byte[] keyBytes;
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        int keyLength = byteBuffer.getInt();
        byte[] byArray = keyBytes = keyLength == -1 ? null : new byte[keyLength];
        if (keyBytes != null) {
            byteBuffer.get(keyBytes);
        }
        byte[] byArray2 = valueBytes = (valueLength = byteBuffer.getInt()) == -1 ? null : new byte[valueLength];
        if (valueBytes != null) {
            byteBuffer.get(valueBytes);
        }
        return decoder.decode(keyBytes, valueBytes);
    }

    @FunctionalInterface
    public static interface KeyValueDecoder<K, V> {
        public KeyValue<K, V> decode(byte[] var1, byte[] var2);
    }
}

