/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire;

import com.google.gson.TypeAdapter;
import io.gsonfire.gson.DateRFC3339TypeAdapter;
import io.gsonfire.gson.DateUnixtimeMillisTypeAdapter;
import io.gsonfire.gson.DateUnixtimeSecondsTypeAdapter;
import io.gsonfire.gson.NullableTypeAdapter;
import java.util.Date;
import java.util.TimeZone;

public enum DateSerializationPolicy {
    unixTimeMillis{

        @Override
        TypeAdapter<Date> createTypeAdapter(TimeZone serializeTimezone) {
            return new NullableTypeAdapter<Date>(new DateUnixtimeMillisTypeAdapter(true));
        }
    }
    ,
    unixTimeSeconds{

        @Override
        TypeAdapter<Date> createTypeAdapter(TimeZone serializeTimezone) {
            return new NullableTypeAdapter<Date>(new DateUnixtimeSecondsTypeAdapter(true));
        }
    }
    ,
    unixTimePositiveMillis{

        @Override
        TypeAdapter<Date> createTypeAdapter(TimeZone serializeTimezone) {
            return new NullableTypeAdapter<Date>(new DateUnixtimeMillisTypeAdapter(false));
        }
    }
    ,
    unixTimePositiveSeconds{

        @Override
        TypeAdapter<Date> createTypeAdapter(TimeZone serializeTimezone) {
            return new NullableTypeAdapter<Date>(new DateUnixtimeSecondsTypeAdapter(false));
        }
    }
    ,
    rfc3339{

        @Override
        TypeAdapter<Date> createTypeAdapter(TimeZone serializeTimezone) {
            return new NullableTypeAdapter<Date>(new DateRFC3339TypeAdapter(serializeTimezone, true));
        }
    }
    ,
    rfc3339Date{

        @Override
        TypeAdapter<Date> createTypeAdapter(TimeZone serializeTimezone) {
            return new NullableTypeAdapter<Date>(new DateRFC3339TypeAdapter(serializeTimezone, false));
        }
    };


    abstract TypeAdapter<Date> createTypeAdapter(TimeZone var1);
}

