/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import lombok.Generated;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.UpdatedHashRanges;

public class ImpactedConsumersResult {
    private final Map<Consumer, UpdatedHashRanges> removedHashRanges;
    private final Map<Consumer, UpdatedHashRanges> addedHashRanges;

    private ImpactedConsumersResult(Map<Consumer, UpdatedHashRanges> removedHashRanges, Map<Consumer, UpdatedHashRanges> addedHashRanges) {
        this.removedHashRanges = removedHashRanges;
        this.addedHashRanges = addedHashRanges;
    }

    public static ImpactedConsumersResult of(Map<Consumer, UpdatedHashRanges> removedHashRanges, Map<Consumer, UpdatedHashRanges> addedHashRanges) {
        return new ImpactedConsumersResult(removedHashRanges, addedHashRanges);
    }

    public void processUpdatedHashRanges(UpdatedHashRangesProcessor processor) {
        this.removedHashRanges.forEach((c, r) -> processor.process((Consumer)c, (UpdatedHashRanges)r, OperationType.REMOVE));
        this.addedHashRanges.forEach((c, r) -> processor.process((Consumer)c, (UpdatedHashRanges)r, OperationType.ADD));
    }

    public boolean isEmpty() {
        return this.removedHashRanges.isEmpty();
    }

    @VisibleForTesting
    Map<Consumer, UpdatedHashRanges> getRemovedHashRanges() {
        return this.removedHashRanges;
    }

    @VisibleForTesting
    Map<Consumer, UpdatedHashRanges> getAddedHashRanges() {
        return this.addedHashRanges;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImpactedConsumersResult)) {
            return false;
        }
        ImpactedConsumersResult other = (ImpactedConsumersResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Consumer, UpdatedHashRanges> this$removedHashRanges = this.getRemovedHashRanges();
        Map<Consumer, UpdatedHashRanges> other$removedHashRanges = other.getRemovedHashRanges();
        if (this$removedHashRanges == null ? other$removedHashRanges != null : !((Object)this$removedHashRanges).equals(other$removedHashRanges)) {
            return false;
        }
        Map<Consumer, UpdatedHashRanges> this$addedHashRanges = this.getAddedHashRanges();
        Map<Consumer, UpdatedHashRanges> other$addedHashRanges = other.getAddedHashRanges();
        return !(this$addedHashRanges == null ? other$addedHashRanges != null : !((Object)this$addedHashRanges).equals(other$addedHashRanges));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImpactedConsumersResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Consumer, UpdatedHashRanges> $removedHashRanges = this.getRemovedHashRanges();
        result = result * 59 + ($removedHashRanges == null ? 43 : ((Object)$removedHashRanges).hashCode());
        Map<Consumer, UpdatedHashRanges> $addedHashRanges = this.getAddedHashRanges();
        result = result * 59 + ($addedHashRanges == null ? 43 : ((Object)$addedHashRanges).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ImpactedConsumersResult(removedHashRanges=" + String.valueOf(this.getRemovedHashRanges()) + ", addedHashRanges=" + String.valueOf(this.getAddedHashRanges()) + ")";
    }

    public static interface UpdatedHashRangesProcessor {
        public void process(Consumer var1, UpdatedHashRanges var2, OperationType var3);
    }

    public static enum OperationType {
        ADD,
        REMOVE;

    }
}

