/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.HashRangeAssignment;
import org.apache.pulsar.broker.service.ImpactedConsumersResult;
import org.apache.pulsar.broker.service.UpdatedHashRanges;
import org.apache.pulsar.client.api.Range;
import org.jspecify.annotations.NonNull;

public class ConsumerHashAssignmentsSnapshot {
    private final List<HashRangeAssignment> hashRangeAssignments;
    private Map<Consumer, List<Range>> cachedRangesByConsumer;

    private ConsumerHashAssignmentsSnapshot(List<HashRangeAssignment> hashRangeAssignments) {
        this.validate(hashRangeAssignments);
        this.hashRangeAssignments = hashRangeAssignments;
    }

    private void validate(List<HashRangeAssignment> hashRangeAssignments) {
        Range previousRange = null;
        for (HashRangeAssignment hashRangeAssignment : hashRangeAssignments) {
            Range range = hashRangeAssignment.range();
            Consumer consumer = hashRangeAssignment.consumer();
            if (range == null || consumer == null) {
                throw new IllegalArgumentException("Range and consumer must not be null");
            }
            if (previousRange != null && previousRange.compareTo(range) >= 0) {
                throw new IllegalArgumentException("Ranges must be non-overlapping and sorted");
            }
            previousRange = range;
        }
    }

    public static ConsumerHashAssignmentsSnapshot of(List<HashRangeAssignment> hashRangeAssignments) {
        return new ConsumerHashAssignmentsSnapshot(hashRangeAssignments);
    }

    public static ConsumerHashAssignmentsSnapshot empty() {
        return new ConsumerHashAssignmentsSnapshot(Collections.emptyList());
    }

    public ImpactedConsumersResult resolveImpactedConsumers(ConsumerHashAssignmentsSnapshot assignmentsAfter) {
        return ConsumerHashAssignmentsSnapshot.resolveConsumerUpdatedHashRanges(this.hashRangeAssignments, assignmentsAfter.hashRangeAssignments);
    }

    public synchronized Map<Consumer, List<Range>> getRangesByConsumer() {
        if (this.cachedRangesByConsumer == null) {
            this.cachedRangesByConsumer = this.internalGetRangesByConsumer();
        }
        return this.cachedRangesByConsumer;
    }

    private @NonNull Map<Consumer, List<Range>> internalGetRangesByConsumer() {
        IdentityHashMap<Consumer, SortedSet> rangesByConsumer = new IdentityHashMap<Consumer, SortedSet>();
        this.hashRangeAssignments.forEach(entry -> {
            Range range = entry.range();
            Consumer consumer = entry.consumer();
            rangesByConsumer.computeIfAbsent(consumer, k -> new TreeSet()).add(range);
        });
        IdentityHashMap<Consumer, List<Range>> mergedOverlappingRangesByConsumer = new IdentityHashMap<Consumer, List<Range>>();
        rangesByConsumer.forEach((consumer, ranges) -> mergedOverlappingRangesByConsumer.put((Consumer)consumer, ConsumerHashAssignmentsSnapshot.mergeOverlappingRanges(ranges)));
        return mergedOverlappingRangesByConsumer;
    }

    @VisibleForTesting
    Map<Range, Pair<Consumer, Consumer>> diffRanges(ConsumerHashAssignmentsSnapshot other) {
        return ConsumerHashAssignmentsSnapshot.diffRanges(this.hashRangeAssignments, other.hashRangeAssignments);
    }

    static ImpactedConsumersResult resolveConsumerUpdatedHashRanges(List<HashRangeAssignment> mappingBefore, List<HashRangeAssignment> mappingAfter) {
        Map<Range, Pair<Consumer, Consumer>> impactedRanges = ConsumerHashAssignmentsSnapshot.diffRanges(mappingBefore, mappingAfter);
        IdentityHashMap<Consumer, SortedSet<Range>> addedRangesByConsumer = new IdentityHashMap<Consumer, SortedSet<Range>>();
        IdentityHashMap<Consumer, SortedSet<Range>> removedRangesByConsumer = new IdentityHashMap<Consumer, SortedSet<Range>>();
        impactedRanges.forEach((range, value) -> {
            Consumer consumerBefore;
            Consumer consumerAfter = (Consumer)value.getRight();
            if (consumerAfter != null) {
                addedRangesByConsumer.computeIfAbsent(consumerAfter, k -> new TreeSet()).add(range);
            }
            if ((consumerBefore = (Consumer)value.getLeft()) != null) {
                removedRangesByConsumer.computeIfAbsent(consumerBefore, k -> new TreeSet()).add(range);
            }
        });
        Map<Consumer, UpdatedHashRanges> removedMerged = ConsumerHashAssignmentsSnapshot.mergedOverlappingRangesAndConvertToImpactedConsumersResult(removedRangesByConsumer);
        Map<Consumer, UpdatedHashRanges> addedMerged = ConsumerHashAssignmentsSnapshot.mergedOverlappingRangesAndConvertToImpactedConsumersResult(addedRangesByConsumer);
        return ImpactedConsumersResult.of(removedMerged, addedMerged);
    }

    static Map<Consumer, UpdatedHashRanges> mergedOverlappingRangesAndConvertToImpactedConsumersResult(Map<Consumer, SortedSet<Range>> updatedRangesByConsumer) {
        IdentityHashMap<Consumer, UpdatedHashRanges> mergedRangesByConsumer = new IdentityHashMap<Consumer, UpdatedHashRanges>();
        updatedRangesByConsumer.forEach((consumer, ranges) -> mergedRangesByConsumer.put((Consumer)consumer, UpdatedHashRanges.of(ConsumerHashAssignmentsSnapshot.mergeOverlappingRanges(ranges))));
        return mergedRangesByConsumer;
    }

    static List<Range> mergeOverlappingRanges(SortedSet<Range> ranges) {
        Range currentRange;
        ArrayList<Range> mergedRanges = new ArrayList<Range>();
        Iterator rangeIterator = ranges.iterator();
        Range range = currentRange = rangeIterator.hasNext() ? (Range)rangeIterator.next() : null;
        while (rangeIterator.hasNext()) {
            Range nextRange = (Range)rangeIterator.next();
            if (currentRange.getEnd() >= nextRange.getStart() - 1) {
                currentRange = Range.of((int)currentRange.getStart(), (int)Math.max(currentRange.getEnd(), nextRange.getEnd()));
                continue;
            }
            mergedRanges.add(currentRange);
            currentRange = nextRange;
        }
        if (currentRange != null) {
            mergedRanges.add(currentRange);
        }
        return mergedRanges;
    }

    static Map<Range, Pair<Consumer, Consumer>> diffRanges(List<HashRangeAssignment> mappingBefore, List<HashRangeAssignment> mappingAfter) {
        HashRangeAssignment afterEntry;
        LinkedHashMap<Range, Pair<Consumer, Consumer>> impactedRanges = new LinkedHashMap<Range, Pair<Consumer, Consumer>>();
        Iterator<HashRangeAssignment> beforeIterator = mappingBefore.iterator();
        Iterator<HashRangeAssignment> afterIterator = mappingAfter.iterator();
        HashRangeAssignment beforeEntry = beforeIterator.hasNext() ? beforeIterator.next() : null;
        HashRangeAssignment hashRangeAssignment = afterEntry = afterIterator.hasNext() ? afterIterator.next() : null;
        while (beforeEntry != null && afterEntry != null) {
            Range beforeRange = beforeEntry.range();
            Range afterRange = afterEntry.range();
            Consumer beforeConsumer = beforeEntry.consumer();
            Consumer afterConsumer = afterEntry.consumer();
            if (beforeRange.equals((Object)afterRange)) {
                if (!beforeConsumer.equals(afterConsumer)) {
                    impactedRanges.put(afterRange, (Pair<Consumer, Consumer>)Pair.of((Object)beforeConsumer, (Object)afterConsumer));
                }
                beforeEntry = beforeIterator.hasNext() ? beforeIterator.next() : null;
                afterEntry = afterIterator.hasNext() ? afterIterator.next() : null;
                continue;
            }
            if (beforeRange.getEnd() < afterRange.getStart()) {
                impactedRanges.put(beforeRange, (Pair<Consumer, Consumer>)Pair.of((Object)beforeConsumer, (Object)afterConsumer));
                beforeEntry = beforeIterator.hasNext() ? beforeIterator.next() : null;
                continue;
            }
            if (afterRange.getEnd() < beforeRange.getStart()) {
                impactedRanges.put(afterRange, (Pair<Consumer, Consumer>)Pair.of((Object)beforeConsumer, (Object)afterConsumer));
                afterEntry = afterIterator.hasNext() ? afterIterator.next() : null;
                continue;
            }
            Range overlapRange = Range.of((int)Math.max(beforeRange.getStart(), afterRange.getStart()), (int)Math.min(beforeRange.getEnd(), afterRange.getEnd()));
            if (!beforeConsumer.equals(afterConsumer)) {
                impactedRanges.put(overlapRange, (Pair<Consumer, Consumer>)Pair.of((Object)beforeConsumer, (Object)afterConsumer));
            }
            if (beforeRange.getEnd() <= overlapRange.getEnd()) {
                HashRangeAssignment hashRangeAssignment2 = beforeEntry = beforeIterator.hasNext() ? beforeIterator.next() : null;
            }
            if (afterRange.getEnd() > overlapRange.getEnd()) continue;
            afterEntry = afterIterator.hasNext() ? afterIterator.next() : null;
        }
        while (beforeEntry != null) {
            impactedRanges.put(beforeEntry.range(), (Pair<Consumer, Consumer>)Pair.of((Object)beforeEntry.consumer(), null));
            beforeEntry = beforeIterator.hasNext() ? beforeIterator.next() : null;
        }
        while (afterEntry != null) {
            impactedRanges.put(afterEntry.range(), (Pair<Consumer, Consumer>)Pair.of(null, (Object)afterEntry.consumer()));
            afterEntry = afterIterator.hasNext() ? afterIterator.next() : null;
        }
        return impactedRanges;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumerHashAssignmentsSnapshot)) {
            return false;
        }
        ConsumerHashAssignmentsSnapshot other = (ConsumerHashAssignmentsSnapshot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<HashRangeAssignment> this$hashRangeAssignments = this.hashRangeAssignments;
        List<HashRangeAssignment> other$hashRangeAssignments = other.hashRangeAssignments;
        return !(this$hashRangeAssignments == null ? other$hashRangeAssignments != null : !((Object)this$hashRangeAssignments).equals(other$hashRangeAssignments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConsumerHashAssignmentsSnapshot;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<HashRangeAssignment> $hashRangeAssignments = this.hashRangeAssignments;
        result = result * 59 + ($hashRangeAssignments == null ? 43 : ((Object)$hashRangeAssignments).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConsumerHashAssignmentsSnapshot(hashRangeAssignments=" + String.valueOf(this.hashRangeAssignments) + ")";
    }
}

