/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Map;
import org.apache.pulsar.broker.loadbalance.ResourceDescription;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;

public class SimpleResourceUnit
implements ResourceUnit {
    private final String resourceId;
    private final ResourceDescription resourceDescription;
    private final Map<String, Object> properties;

    public SimpleResourceUnit(String resourceId, ResourceDescription resourceDescription) {
        this.resourceId = resourceId;
        this.resourceDescription = resourceDescription;
        this.properties = Collections.emptyMap();
    }

    public SimpleResourceUnit(String resourceId, ResourceDescription resourceDescription, Map<String, Object> properties) {
        this.resourceId = resourceId;
        this.resourceDescription = resourceDescription;
        this.properties = properties == null ? Collections.emptyMap() : properties;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public ResourceDescription getAvailableResource() {
        return null;
    }

    @Override
    public boolean canFit(ResourceDescription resourceDescription) {
        return this.resourceDescription.compareTo(resourceDescription) > 0;
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public int compareTo(ResourceUnit o) {
        return this.resourceId.compareTo(o.getResourceId());
    }

    public boolean equals(Object o) {
        if (!(o instanceof SimpleResourceUnit)) {
            return false;
        }
        SimpleResourceUnit other = (SimpleResourceUnit)o;
        return this.resourceId.equals(other.resourceId);
    }

    public int hashCode() {
        return this.resourceId.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("resourceId", (Object)this.resourceId).toString();
    }
}

