/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.ModularLoadManager;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.apache.pulsar.broker.loadbalance.extensions.ExtensibleLoadManager;
import org.apache.pulsar.broker.loadbalance.extensions.ExtensibleLoadManagerImpl;
import org.apache.pulsar.broker.loadbalance.extensions.ExtensibleLoadManagerWrapper;
import org.apache.pulsar.broker.loadbalance.impl.ModularLoadManagerWrapper;
import org.apache.pulsar.broker.loadbalance.impl.SimpleLoadManagerImpl;
import org.apache.pulsar.broker.lookup.LookupResult;
import org.apache.pulsar.broker.namespace.LookupOptions;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.Reflections;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LoadManager {
    public static final Logger LOG = LoggerFactory.getLogger(LoadManager.class);
    public static final String LOADBALANCE_BROKERS_ROOT = "/loadbalance/brokers";

    public void start() throws PulsarServerException;

    default public boolean started() {
        return true;
    }

    public boolean isCentralized();

    public Optional<ResourceUnit> getLeastLoaded(ServiceUnitId var1) throws Exception;

    default public CompletableFuture<Optional<LookupResult>> findBrokerServiceUrl(Optional<ServiceUnitId> topic, ServiceUnitId bundle, LookupOptions options) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<Boolean> checkOwnershipAsync(Optional<ServiceUnitId> topic, ServiceUnitId bundle) {
        throw new UnsupportedOperationException();
    }

    public LoadManagerReport generateLoadReport() throws Exception;

    public void setLoadReportForceUpdateFlag();

    public void writeLoadReportOnZookeeper() throws Exception;

    default public void writeLoadReportOnZookeeper(boolean force) throws Exception {
        this.writeLoadReportOnZookeeper();
    }

    public void writeResourceQuotasToZooKeeper() throws Exception;

    public List<Metrics> getLoadBalancingMetrics();

    public void doLoadShedding();

    public void doNamespaceBundleSplit() throws Exception;

    public void disableBroker() throws Exception;

    public Set<String> getAvailableBrokers() throws Exception;

    public CompletableFuture<Set<String>> getAvailableBrokersAsync();

    public String setNamespaceBundleAffinity(String var1, String var2);

    public void stop() throws PulsarServerException;

    public void initialize(PulsarService var1);

    public static LoadManager create(PulsarService pulsar) {
        try {
            Object loadManagerInstance;
            ServiceConfiguration conf = pulsar.getConfiguration();
            String loadManagerClassName = conf.getLoadManagerClassName();
            if (StringUtils.isBlank((CharSequence)loadManagerClassName)) {
                loadManagerClassName = SimpleLoadManagerImpl.class.getName();
            }
            if ((loadManagerInstance = Reflections.createInstance((String)loadManagerClassName, (ClassLoader)Thread.currentThread().getContextClassLoader())) instanceof LoadManager) {
                LoadManager casted = (LoadManager)loadManagerInstance;
                casted.initialize(pulsar);
                return casted;
            }
            if (loadManagerInstance instanceof ModularLoadManager) {
                ModularLoadManager modularLoadManager = (ModularLoadManager)loadManagerInstance;
                ModularLoadManagerWrapper casted = new ModularLoadManagerWrapper(modularLoadManager);
                casted.initialize(pulsar);
                return casted;
            }
            if (loadManagerInstance instanceof ExtensibleLoadManager) {
                ExtensibleLoadManagerWrapper casted = new ExtensibleLoadManagerWrapper((ExtensibleLoadManagerImpl)loadManagerInstance);
                casted.initialize(pulsar);
                return casted;
            }
        }
        catch (Exception e) {
            LOG.warn("Error when trying to create load manager: ", (Throwable)e);
        }
        return new SimpleLoadManagerImpl(pulsar);
    }
}

