/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.oxia.client.metrics.Unit;

public class Counter {
    private final LongCounter counter;
    private final Attributes attributes;

    Counter(Meter meter, String name, Unit unit, String description, String namespace, Attributes attributes) {
        LongCounterBuilder builder = meter.counterBuilder(name).setDescription(description).setUnit(unit.toString());
        attributes = attributes.toBuilder().put("oxia.namespace", namespace).build();
        this.counter = builder.build();
        this.attributes = attributes;
    }

    public void increment() {
        this.add(1L);
    }

    public void add(long delta) {
        this.counter.add(delta, this.attributes);
    }
}

