/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema.validator;

import java.nio.charset.StandardCharsets;
import org.apache.pulsar.broker.service.schema.exceptions.InvalidSchemaDataException;
import org.apache.pulsar.broker.service.schema.validator.SchemaDataValidator;
import org.apache.pulsar.common.protocol.schema.SchemaData;

class StringSchemaDataValidator
implements SchemaDataValidator {
    private static final StringSchemaDataValidator INSTANCE = new StringSchemaDataValidator();
    private static final String PY_NONE_SCHEMA_INFO = "null";

    public static final StringSchemaDataValidator of() {
        return INSTANCE;
    }

    private StringSchemaDataValidator() {
    }

    @Override
    public void validate(SchemaData schemaData) throws InvalidSchemaDataException {
        String schemaDataStr;
        byte[] data = schemaData.getData();
        if (null != data && data.length > 0 && !PY_NONE_SCHEMA_INFO.equals(schemaDataStr = new String(data, StandardCharsets.UTF_8))) {
            throw new InvalidSchemaDataException("Invalid schema definition data for string schema : '" + schemaDataStr + "'");
        }
    }
}

