/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.container;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannelManager;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannel;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannelFactory;
import org.apache.bookkeeper.clients.impl.internal.api.LocationClient;
import org.apache.bookkeeper.common.util.OrderedScheduler;

public class StorageContainerChannelManager
implements AutoCloseable {
    private final StorageContainerChannelFactory factory;
    private final ConcurrentMap<Long, StorageContainerChannel> scChannels;

    public StorageContainerChannelManager(StorageServerChannelManager channelManager, LocationClient locationClient, OrderedScheduler scheduler) {
        this(scId -> new StorageContainerChannel(scId, channelManager, locationClient, (ScheduledExecutorService)scheduler.chooseThread(scId)));
    }

    @VisibleForTesting
    StorageContainerChannelManager(StorageContainerChannelFactory factory) {
        this.factory = factory;
        this.scChannels = Maps.newConcurrentMap();
    }

    @VisibleForTesting
    int getNumChannels() {
        return this.scChannels.size();
    }

    public StorageContainerChannel getOrCreate(long scId) {
        StorageContainerChannel scChannel = (StorageContainerChannel)this.scChannels.get(scId);
        if (null == scChannel) {
            StorageContainerChannel newChannel = this.factory.createStorageContainerChannel(scId);
            StorageContainerChannel oldChannel = this.scChannels.putIfAbsent(scId, newChannel);
            scChannel = null == oldChannel ? newChannel : oldChannel;
        }
        return scChannel;
    }

    public StorageContainerChannel remove(long scId) {
        return (StorageContainerChannel)this.scChannels.remove(scId);
    }

    @Override
    public void close() throws Exception {
        this.scChannels.clear();
    }
}

