/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Objects;

public class Daemon
extends Thread {
    protected Daemon(Builder builder) {
        super(builder.threadGroup, builder.runnable);
        this.setDaemon(true);
        this.setName(builder.name);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private Runnable runnable;
        private ThreadGroup threadGroup;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setRunnable(Runnable runnable2) {
            this.runnable = runnable2;
            return this;
        }

        public Builder setThreadGroup(ThreadGroup threadGroup) {
            this.threadGroup = threadGroup;
            return this;
        }

        public Daemon build() {
            Objects.requireNonNull(this.name, "name == null");
            return new Daemon(this);
        }
    }
}

