/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.apache.ratis.grpc.util.ResponseNotifyClientInterceptor;
import org.apache.ratis.protocol.exceptions.TimeoutIOException;
import org.apache.ratis.thirdparty.io.grpc.ClientInterceptor;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.ResourceSemaphore;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutExecutor;
import org.apache.ratis.util.function.StringSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamObserverWithTimeout<T>
implements StreamObserver<T> {
    public static final Logger LOG = LoggerFactory.getLogger(StreamObserverWithTimeout.class);
    private final String name;
    private final Function<T, String> requestToStringFunction;
    private final Supplier<TimeDuration> timeoutSupplier;
    private final StreamObserver<T> observer;
    private final TimeoutExecutor scheduler = TimeoutExecutor.getInstance();
    private final AtomicBoolean isClose = new AtomicBoolean();
    private final AtomicInteger requestCount = new AtomicInteger();
    private final IntSupplier responseCount;
    private final ResourceSemaphore semaphore;

    public static <T> StreamObserverWithTimeout<T> newInstance(String name, Function<T, String> request2String, Supplier<TimeDuration> timeout2, int outstandingLimit, Function<ClientInterceptor, StreamObserver<T>> newStreamObserver) {
        AtomicInteger responseCount = new AtomicInteger();
        ResourceSemaphore semaphore = outstandingLimit > 0 ? new ResourceSemaphore(outstandingLimit) : null;
        ResponseNotifyClientInterceptor interceptor = new ResponseNotifyClientInterceptor(r -> {
            responseCount.getAndIncrement();
            if (semaphore != null) {
                semaphore.release();
            }
        });
        return new StreamObserverWithTimeout<T>(name, request2String, timeout2, responseCount::get, semaphore, newStreamObserver.apply(interceptor));
    }

    private StreamObserverWithTimeout(String name, Function<T, String> requestToStringFunction, Supplier<TimeDuration> timeoutSupplier, IntSupplier responseCount, ResourceSemaphore semaphore, StreamObserver<T> observer) {
        this.name = JavaUtils.getClassSimpleName(this.getClass()) + "-" + name;
        this.requestToStringFunction = requestToStringFunction;
        this.timeoutSupplier = timeoutSupplier;
        this.responseCount = responseCount;
        this.semaphore = semaphore;
        this.observer = observer;
    }

    private void acquire(StringSupplier request, TimeDuration timeout2) {
        if (this.semaphore == null) {
            return;
        }
        boolean acquired = false;
        while (!acquired && !this.isClose.get()) {
            try {
                acquired = this.semaphore.tryAcquire(timeout2.getDuration(), timeout2.getUnit());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted onNext " + request, e);
            }
        }
        if (!acquired) {
            throw new IllegalStateException("Failed onNext " + request + ": already closed.");
        }
    }

    @Override
    public void onNext(T request) {
        StringSupplier requestString = StringSupplier.get(() -> this.requestToStringFunction.apply(request));
        TimeDuration timeout2 = this.timeoutSupplier.get();
        this.acquire(requestString, timeout2);
        this.observer.onNext(request);
        int id = this.requestCount.incrementAndGet();
        LOG.debug("{}: send {} with timeout={}: {}", new Object[]{this.name, id, timeout2, requestString});
        this.scheduler.onTimeout(timeout2, () -> this.handleTimeout(id, timeout2, requestString), LOG, () -> this.name + ": Timeout check failed for request: " + requestString);
    }

    private void handleTimeout(int id, TimeDuration timeout2, StringSupplier request) {
        if (id > this.responseCount.getAsInt()) {
            this.onError(new TimeoutIOException(this.name + ": Timed out " + timeout2 + " for sending request " + request));
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.isClose.compareAndSet(false, true)) {
            this.observer.onError(throwable);
        }
    }

    @Override
    public void onCompleted() {
        if (this.isClose.compareAndSet(false, true)) {
            this.observer.onCompleted();
        }
    }

    public String toString() {
        return this.name;
    }
}

