/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.util.Time;
import org.apache.ratis.util.function.CheckedRunnable;
import org.apache.ratis.util.function.CheckedSupplier;

public final class MetricUtil {
    private MetricUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> T captureLatencyNs(MutableRate metric, CheckedSupplier<T, E> block) throws E {
        long start = Time.monotonicNowNanos();
        try {
            T t2 = block.get();
            return t2;
        }
        finally {
            metric.add(Time.monotonicNowNanos() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends IOException> void captureLatencyNs(MutableRate metric, CheckedRunnable<E> block) throws IOException {
        long start = Time.monotonicNowNanos();
        try {
            block.run();
        }
        finally {
            metric.add(Time.monotonicNowNanos() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends IOException> T captureLatencyNs(Consumer<Long> latencySetter, CheckedSupplier<T, E> block) throws E {
        long start = Time.monotonicNowNanos();
        try {
            T t2 = block.get();
            return t2;
        }
        finally {
            latencySetter.accept(Time.monotonicNowNanos() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends IOException> void captureLatencyNs(Consumer<Long> latencySetter, CheckedRunnable<E> block) throws E {
        long start = Time.monotonicNowNanos();
        try {
            block.run();
        }
        finally {
            latencySetter.accept(Time.monotonicNowNanos() - start);
        }
    }

    public static List<MutableQuantiles> createQuantiles(MetricsRegistry registry, String name, String description, String sampleName, String valueName, int ... intervals) {
        if (intervals == null) {
            throw new IllegalArgumentException("At least one interval should be provided.");
        }
        if (intervals.length == 0) {
            return new ArrayList<MutableQuantiles>();
        }
        return Arrays.stream(intervals).mapToObj(interval -> {
            String quantileName = name + interval + "s";
            return registry.newQuantiles(quantileName, description, sampleName, valueName, interval);
        }).collect(Collectors.toList());
    }

    public static void stop(MutableQuantiles ... quantiles) {
        if (quantiles != null) {
            MetricUtil.stop(Arrays.asList(quantiles));
        }
    }

    public static void stop(Iterable<MutableQuantiles> quantiles) {
        if (quantiles != null) {
            for (MutableQuantiles q : quantiles) {
                if (q == null) continue;
                q.stop();
            }
        }
    }
}

