/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.its.bc;

import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x9.X9ECParameters;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.its.ITSPublicVerificationKey;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.math.ec.ECCurve;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.math.ec.ECPoint;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.oer.its.ieee1609dot2.basetypes.EccCurvePoint;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.oer.its.ieee1609dot2.basetypes.EccP256CurvePoint;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.oer.its.ieee1609dot2.basetypes.EccP384CurvePoint;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.oer.its.ieee1609dot2.basetypes.Point256;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.oer.its.ieee1609dot2.basetypes.Point384;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.oer.its.ieee1609dot2.basetypes.PublicVerificationKey;

public class BcITSPublicVerificationKey
extends ITSPublicVerificationKey {
    public BcITSPublicVerificationKey(PublicVerificationKey publicVerificationKey) {
        super(publicVerificationKey);
    }

    static PublicVerificationKey fromKeyParameters(ECPublicKeyParameters eCPublicKeyParameters) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = ((ECNamedDomainParameters)eCPublicKeyParameters.getParameters()).getName();
        ECPoint eCPoint = eCPublicKeyParameters.getQ();
        if (aSN1ObjectIdentifier.equals(SECObjectIdentifiers.secp256r1)) {
            return new PublicVerificationKey(0, EccP256CurvePoint.uncompressedP256(Point256.builder().setX(eCPoint.getAffineXCoord().toBigInteger()).setY(eCPoint.getAffineYCoord().toBigInteger()).createPoint256()));
        }
        if (aSN1ObjectIdentifier.equals(TeleTrusTObjectIdentifiers.brainpoolP256r1)) {
            return new PublicVerificationKey(1, EccP256CurvePoint.uncompressedP256(Point256.builder().setX(eCPoint.getAffineXCoord().toBigInteger()).setY(eCPoint.getAffineYCoord().toBigInteger()).createPoint256()));
        }
        if (aSN1ObjectIdentifier.equals(TeleTrusTObjectIdentifiers.brainpoolP384r1)) {
            return new PublicVerificationKey(2, EccP384CurvePoint.uncompressedP384(Point384.builder().setX(eCPoint.getAffineXCoord().toBigInteger()).setY(eCPoint.getAffineYCoord().toBigInteger()).createPoint384()));
        }
        throw new IllegalArgumentException("unknown curve in public encryption key");
    }

    public BcITSPublicVerificationKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        super(BcITSPublicVerificationKey.fromKeyParameters((ECPublicKeyParameters)asymmetricKeyParameter));
    }

    public AsymmetricKeyParameter getKey() {
        byte[] byArray;
        X9ECParameters x9ECParameters;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        switch (this.verificationKey.getChoice()) {
            case 0: {
                aSN1ObjectIdentifier = SECObjectIdentifiers.secp256r1;
                x9ECParameters = NISTNamedCurves.getByOID(SECObjectIdentifiers.secp256r1);
                break;
            }
            case 1: {
                aSN1ObjectIdentifier = TeleTrusTObjectIdentifiers.brainpoolP256r1;
                x9ECParameters = TeleTrusTNamedCurves.getByOID(TeleTrusTObjectIdentifiers.brainpoolP256r1);
                break;
            }
            case 2: {
                aSN1ObjectIdentifier = TeleTrusTObjectIdentifiers.brainpoolP384r1;
                x9ECParameters = TeleTrusTNamedCurves.getByOID(TeleTrusTObjectIdentifiers.brainpoolP384r1);
                break;
            }
            default: {
                throw new IllegalStateException("unknown key type");
            }
        }
        ECCurve eCCurve = x9ECParameters.getCurve();
        ASN1Encodable aSN1Encodable = this.verificationKey.getPublicVerificationKey();
        if (!(aSN1Encodable instanceof EccCurvePoint)) {
            throw new IllegalStateException("extension to public verification key not supported");
        }
        EccCurvePoint eccCurvePoint = (EccCurvePoint)this.verificationKey.getPublicVerificationKey();
        if (eccCurvePoint instanceof EccP256CurvePoint) {
            byArray = eccCurvePoint.getEncodedPoint();
        } else if (eccCurvePoint instanceof EccP384CurvePoint) {
            byArray = eccCurvePoint.getEncodedPoint();
        } else {
            throw new IllegalStateException("unknown key type");
        }
        ECPoint eCPoint = eCCurve.decodePoint(byArray).normalize();
        return new ECPublicKeyParameters(eCPoint, (ECDomainParameters)new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters));
    }
}

