/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.jcajce;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.crypto.Cipher;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.InputStreamWithMAC;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.jcajce.JceAADStream;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.jcajce.io.CipherInputStream;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.InputAEADDecryptor;

class CMSInputAEADDecryptor
implements InputAEADDecryptor {
    private final AlgorithmIdentifier contentEncryptionAlgorithm;
    private final Cipher dataCipher;
    private InputStream inputStream;

    CMSInputAEADDecryptor(AlgorithmIdentifier algorithmIdentifier, Cipher cipher) {
        this.contentEncryptionAlgorithm = algorithmIdentifier;
        this.dataCipher = cipher;
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.contentEncryptionAlgorithm;
    }

    @Override
    public InputStream getInputStream(InputStream inputStream2) {
        this.inputStream = inputStream2;
        return new CipherInputStream(inputStream2, this.dataCipher);
    }

    @Override
    public OutputStream getAADStream() {
        if (CMSInputAEADDecryptor.checkForAEAD()) {
            return new JceAADStream(this.dataCipher);
        }
        return null;
    }

    @Override
    public byte[] getMAC() {
        if (this.inputStream instanceof InputStreamWithMAC) {
            return ((InputStreamWithMAC)this.inputStream).getMAC();
        }
        return null;
    }

    private static boolean checkForAEAD() {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Cipher.class.getMethod("updateAAD", byte[].class) != null;
                }
                catch (Exception exception) {
                    return Boolean.FALSE;
                }
            }
        });
    }
}

