/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Integer;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.BERSequenceGenerator;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.BERTaggedObject;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.DERSet;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.cms.SignerInfo;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSSignedGenerator;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSSignedHelper;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSStreamException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSUtils;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.SignerInfoGenerator;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.SignerInformation;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;

public class CMSSignedDataStreamGenerator
extends CMSSignedGenerator {
    private int _bufferSize;

    public CMSSignedDataStreamGenerator() {
    }

    public CMSSignedDataStreamGenerator(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        super(digestAlgorithmIdentifierFinder);
    }

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public OutputStream open(OutputStream outputStream2) throws IOException {
        return this.open(outputStream2, false);
    }

    public OutputStream open(OutputStream outputStream2, boolean bl) throws IOException {
        return this.open(CMSObjectIdentifiers.data, outputStream2, bl);
    }

    public OutputStream open(OutputStream outputStream2, boolean bl, OutputStream outputStream3) throws IOException {
        return this.open(CMSObjectIdentifiers.data, outputStream2, bl, outputStream3);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream2, boolean bl) throws IOException {
        return this.open(aSN1ObjectIdentifier, outputStream2, bl, null);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream2, boolean bl, OutputStream outputStream3) throws IOException {
        Object object2;
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream2);
        bERSequenceGenerator.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject(this.calculateVersion(aSN1ObjectIdentifier));
        HashSet<AlgorithmIdentifier> hashSet = new HashSet<AlgorithmIdentifier>();
        for (Object object2 : this._signers) {
            CMSUtils.addDigestAlgs(hashSet, (SignerInformation)object2, this.digestAlgIdFinder);
        }
        for (Object object2 : this.signerGens) {
            hashSet.add(((SignerInfoGenerator)object2).getDigestAlgorithm());
        }
        bERSequenceGenerator2.getRawOutputStream().write(CMSUtils.convertToDlSet(hashSet).getEncoded());
        BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject(aSN1ObjectIdentifier);
        object2 = bl ? CMSUtils.createBEROctetOutputStream(bERSequenceGenerator3.getRawOutputStream(), 0, true, this._bufferSize) : null;
        OutputStream outputStream4 = CMSUtils.getSafeTeeOutputStream(outputStream3, (OutputStream)object2);
        OutputStream outputStream5 = CMSUtils.attachSignersToOutputStream(this.signerGens, outputStream4);
        return new CmsSignedDataOutputStream(outputStream5, aSN1ObjectIdentifier, bERSequenceGenerator, bERSequenceGenerator2, bERSequenceGenerator3);
    }

    public List<AlgorithmIdentifier> getDigestAlgorithms() {
        ArrayList<AlgorithmIdentifier> arrayList = new ArrayList<AlgorithmIdentifier>();
        for (Object object : this._signers) {
            AlgorithmIdentifier algorithmIdentifier = CMSSignedHelper.INSTANCE.fixDigestAlgID(((SignerInformation)object).getDigestAlgorithmID(), this.digestAlgIdFinder);
            arrayList.add(algorithmIdentifier);
        }
        for (Object object : this.signerGens) {
            arrayList.add(((SignerInfoGenerator)object).getDigestAlgorithm());
        }
        return arrayList;
    }

    private ASN1Integer calculateVersion(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.certs != null) {
            for (Object e : this.certs) {
                if (!(e instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)e;
                if (aSN1TaggedObject.getTagNo() == 1) {
                    bl3 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() == 2) {
                    bl4 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() != 3) continue;
                bl = true;
            }
        }
        if (bl) {
            return new ASN1Integer(5L);
        }
        if (this.crls != null) {
            for (Object e : this.crls) {
                if (!(e instanceof ASN1TaggedObject)) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            return new ASN1Integer(5L);
        }
        if (bl4) {
            return new ASN1Integer(4L);
        }
        if (bl3) {
            return new ASN1Integer(3L);
        }
        if (this.checkForVersion3(this._signers, this.signerGens)) {
            return new ASN1Integer(3L);
        }
        if (!CMSObjectIdentifiers.data.equals(aSN1ObjectIdentifier)) {
            return new ASN1Integer(3L);
        }
        return new ASN1Integer(1L);
    }

    private boolean checkForVersion3(List list, List list2) {
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            Object object = SignerInfo.getInstance(((SignerInformation)iterator2.next()).toASN1Structure());
            if (((SignerInfo)object).getVersion().intValueExact() != 3) continue;
            return true;
        }
        for (Object object : list2) {
            if (((SignerInfoGenerator)object).getGeneratedVersion() != 3) continue;
            return true;
        }
        return false;
    }

    private class CmsSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private ASN1ObjectIdentifier _contentOID;
        private BERSequenceGenerator _sGen;
        private BERSequenceGenerator _sigGen;
        private BERSequenceGenerator _eiGen;

        public CmsSignedDataOutputStream(OutputStream outputStream2, ASN1ObjectIdentifier aSN1ObjectIdentifier, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this._out = outputStream2;
            this._contentOID = aSN1ObjectIdentifier;
            this._sGen = bERSequenceGenerator;
            this._sigGen = bERSequenceGenerator2;
            this._eiGen = bERSequenceGenerator3;
        }

        @Override
        public void write(int n) throws IOException {
            this._out.write(n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._out.write(byArray, n, n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this._out.write(byArray);
        }

        @Override
        public void close() throws IOException {
            Object object;
            this._out.close();
            this._eiGen.close();
            CMSSignedDataStreamGenerator.this.digests.clear();
            if (CMSSignedDataStreamGenerator.this.certs.size() != 0) {
                object = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.certs);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 0, (ASN1Encodable)object).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this.crls.size() != 0) {
                object = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.crls);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 1, (ASN1Encodable)object).getEncoded());
            }
            object = new ASN1EncodableVector();
            for (Object object2 : CMSSignedDataStreamGenerator.this.signerGens) {
                try {
                    ((ASN1EncodableVector)object).add(((SignerInfoGenerator)object2).generate(this._contentOID));
                    byte[] byArray = ((SignerInfoGenerator)object2).getCalculatedDigest();
                    CMSSignedDataStreamGenerator.this.digests.put(((SignerInfoGenerator)object2).getDigestAlgorithm().getAlgorithm().getId(), byArray);
                }
                catch (CMSException cMSException) {
                    throw new CMSStreamException("exception generating signers: " + cMSException.getMessage(), cMSException);
                }
            }
            for (Object object2 : CMSSignedDataStreamGenerator.this._signers) {
                ((ASN1EncodableVector)object).add(((SignerInformation)object2).toASN1Structure());
            }
            this._sigGen.getRawOutputStream().write(new DERSet((ASN1EncodableVector)object).getEncoded());
            this._sigGen.close();
            this._sGen.close();
        }
    }
}

