/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Integer;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.BERSequenceGenerator;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.DEROctetString;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.DERSet;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.DERTaggedObject;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.cms.AuthenticatedData;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSAuthenticatedGenerator;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSUtils;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.DigestCalculator;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.MacCalculator;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.util.io.TeeOutputStream;

public class CMSAuthenticatedDataStreamGenerator
extends CMSAuthenticatedGenerator {
    private int bufferSize;
    private boolean berEncodeRecipientSet;
    private MacCalculator macCalculator;

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public void setBEREncodeRecipients(boolean bl) {
        this.berEncodeRecipientSet = bl;
    }

    public OutputStream open(OutputStream outputStream2, MacCalculator macCalculator) throws CMSException {
        return this.open(CMSObjectIdentifiers.data, outputStream2, macCalculator);
    }

    public OutputStream open(OutputStream outputStream2, MacCalculator macCalculator, DigestCalculator digestCalculator) throws CMSException {
        return this.open(CMSObjectIdentifiers.data, outputStream2, macCalculator, digestCalculator);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream2, MacCalculator macCalculator) throws CMSException {
        return this.open(aSN1ObjectIdentifier, outputStream2, macCalculator, null);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream2, MacCalculator macCalculator, DigestCalculator digestCalculator) throws CMSException {
        this.macCalculator = macCalculator;
        try {
            ASN1EncodableVector aSN1EncodableVector = CMSUtils.getRecipentInfos(macCalculator.getKey(), this.recipientInfoGenerators);
            BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream2);
            bERSequenceGenerator.addObject(CMSObjectIdentifiers.authenticatedData);
            BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
            bERSequenceGenerator2.addObject(new ASN1Integer(AuthenticatedData.calculateVersion(this.originatorInfo)));
            CMSUtils.addOriginatorInfoToGenerator(bERSequenceGenerator2, this.originatorInfo);
            CMSUtils.addRecipientInfosToGenerator(aSN1EncodableVector, bERSequenceGenerator2, this.berEncodeRecipientSet);
            AlgorithmIdentifier algorithmIdentifier = macCalculator.getAlgorithmIdentifier();
            bERSequenceGenerator2.getRawOutputStream().write(algorithmIdentifier.getEncoded());
            if (digestCalculator != null) {
                bERSequenceGenerator2.addObject(new DERTaggedObject(false, 1, (ASN1Encodable)digestCalculator.getAlgorithmIdentifier()));
            }
            BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
            bERSequenceGenerator3.addObject(aSN1ObjectIdentifier);
            OutputStream outputStream3 = CMSUtils.createBEROctetOutputStream(bERSequenceGenerator3.getRawOutputStream(), 0, true, this.bufferSize);
            TeeOutputStream teeOutputStream = digestCalculator != null ? new TeeOutputStream(outputStream3, digestCalculator.getOutputStream()) : new TeeOutputStream(outputStream3, macCalculator.getOutputStream());
            return new CmsAuthenticatedDataOutputStream(macCalculator, digestCalculator, aSN1ObjectIdentifier, teeOutputStream, bERSequenceGenerator, bERSequenceGenerator2, bERSequenceGenerator3);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
    }

    private class CmsAuthenticatedDataOutputStream
    extends OutputStream {
        private OutputStream dataStream;
        private BERSequenceGenerator cGen;
        private BERSequenceGenerator envGen;
        private BERSequenceGenerator eiGen;
        private MacCalculator macCalculator;
        private DigestCalculator digestCalculator;
        private ASN1ObjectIdentifier contentType;

        public CmsAuthenticatedDataOutputStream(MacCalculator macCalculator, DigestCalculator digestCalculator, ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream2, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this.macCalculator = macCalculator;
            this.digestCalculator = digestCalculator;
            this.contentType = aSN1ObjectIdentifier;
            this.dataStream = outputStream2;
            this.cGen = bERSequenceGenerator;
            this.envGen = bERSequenceGenerator2;
            this.eiGen = bERSequenceGenerator3;
        }

        @Override
        public void write(int n) throws IOException {
            this.dataStream.write(n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dataStream.write(byArray, n, n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.dataStream.write(byArray);
        }

        @Override
        public void close() throws IOException {
            Map map;
            this.dataStream.close();
            this.eiGen.close();
            if (this.digestCalculator != null) {
                map = Collections.unmodifiableMap(CMSAuthenticatedDataStreamGenerator.this.getBaseParameters(this.contentType, this.digestCalculator.getAlgorithmIdentifier(), this.macCalculator.getAlgorithmIdentifier(), this.digestCalculator.getDigest()));
                if (CMSAuthenticatedDataStreamGenerator.this.authGen == null) {
                    CMSAuthenticatedDataStreamGenerator.this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
                }
                DERSet dERSet = new DERSet(CMSAuthenticatedDataStreamGenerator.this.authGen.getAttributes(map).toASN1EncodableVector());
                OutputStream outputStream2 = this.macCalculator.getOutputStream();
                outputStream2.write(dERSet.getEncoded("DER"));
                outputStream2.close();
                this.envGen.addObject(new DERTaggedObject(false, 2, (ASN1Encodable)dERSet));
            } else {
                map = Collections.EMPTY_MAP;
            }
            this.envGen.addObject(new DEROctetString(this.macCalculator.getMac()));
            CMSUtils.addAttriSetToGenerator(this.envGen, CMSAuthenticatedDataStreamGenerator.this.unauthGen, 3, map);
            this.envGen.close();
            this.cGen.close();
        }
    }
}

