/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1OctetString;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1OctetStringParser;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1SequenceParser;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Set;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1SetParser;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.cms.AttributeTable;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.cms.AuthenticatedDataParser;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.cms.CMSAttributes;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.cms.ContentInfoParser;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.cms.OriginatorInfo;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSContentInfoParser;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSEnvelopedHelper;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSProcessableInputStream;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSSecureReadable;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.CMSUtils;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.OriginatorInformation;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cms.RecipientInformationStore;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.DigestCalculatorProvider;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.OperatorCreationException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.util.Arrays;

public class CMSAuthenticatedDataParser
extends CMSContentInfoParser {
    RecipientInformationStore recipientInfoStore;
    AuthenticatedDataParser authData = new AuthenticatedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
    private AlgorithmIdentifier macAlg;
    private byte[] mac;
    private AttributeTable authAttrs;
    private ASN1Set authAttrSet;
    private AttributeTable unauthAttrs;
    private boolean authAttrNotRead = true;
    private boolean unauthAttrNotRead;
    private OriginatorInformation originatorInfo;
    private CMSSecureReadable secureReadable;

    public CMSAuthenticatedDataParser(byte[] byArray) throws CMSException, IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public CMSAuthenticatedDataParser(byte[] byArray, DigestCalculatorProvider digestCalculatorProvider) throws CMSException, IOException {
        this(new ByteArrayInputStream(byArray), digestCalculatorProvider);
    }

    public CMSAuthenticatedDataParser(InputStream inputStream2) throws CMSException, IOException {
        this(inputStream2, null);
    }

    public CMSAuthenticatedDataParser(InputStream inputStream2, DigestCalculatorProvider digestCalculatorProvider) throws CMSException, IOException {
        super(inputStream2);
        OriginatorInfo originatorInfo = this.authData.getOriginatorInfo();
        if (originatorInfo != null) {
            this.originatorInfo = new OriginatorInformation(originatorInfo);
        }
        ASN1Set aSN1Set = ASN1Set.getInstance(this.authData.getRecipientInfos().toASN1Primitive());
        this.macAlg = this.authData.getMacAlgorithm();
        AlgorithmIdentifier algorithmIdentifier = this.authData.getDigestAlgorithm();
        if (algorithmIdentifier != null) {
            if (digestCalculatorProvider == null) {
                throw new CMSException("a digest calculator provider is required if authenticated attributes are present");
            }
            ContentInfoParser contentInfoParser = this.authData.getEncapsulatedContentInfo();
            CMSProcessableInputStream cMSProcessableInputStream = new CMSProcessableInputStream(((ASN1OctetStringParser)contentInfoParser.getContent(4)).getOctetStream());
            try {
                this.secureReadable = new CMSEnvelopedHelper.CMSDigestAuthenticatedSecureReadable(digestCalculatorProvider.get(algorithmIdentifier), contentInfoParser.getContentType(), cMSProcessableInputStream);
                this.recipientInfoStore = CMSEnvelopedHelper.buildRecipientInformationStore(aSN1Set, this.macAlg, this.secureReadable);
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CMSException("unable to create digest calculator: " + operatorCreationException.getMessage(), operatorCreationException);
            }
        } else {
            ContentInfoParser contentInfoParser = this.authData.getEncapsulatedContentInfo();
            CMSProcessableInputStream cMSProcessableInputStream = new CMSProcessableInputStream(((ASN1OctetStringParser)contentInfoParser.getContent(4)).getOctetStream());
            this.secureReadable = new CMSEnvelopedHelper.CMSAuthEnveSecureReadable(this.macAlg, contentInfoParser.getContentType(), cMSProcessableInputStream);
            this.recipientInfoStore = CMSEnvelopedHelper.buildRecipientInformationStore(aSN1Set, this.macAlg, this.secureReadable);
        }
    }

    public OriginatorInformation getOriginatorInfo() {
        return this.originatorInfo;
    }

    public AlgorithmIdentifier getMacAlgorithm() {
        return this.macAlg;
    }

    public String getMacAlgOID() {
        return this.macAlg.getAlgorithm().toString();
    }

    public byte[] getMacAlgParams() {
        try {
            return CMSUtils.encodeObj(this.macAlg.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public byte[] getMac() throws IOException {
        if (this.mac == null) {
            this.getAuthAttrs();
            this.mac = this.authData.getMac().getOctets();
        }
        return Arrays.clone(this.mac);
    }

    private ASN1Set getAuthAttrSet() throws IOException {
        if (this.authAttrs == null && this.authAttrNotRead) {
            ASN1SetParser aSN1SetParser = this.authData.getAuthAttrs();
            if (aSN1SetParser != null) {
                this.authAttrSet = (ASN1Set)aSN1SetParser.toASN1Primitive();
            }
            this.authAttrNotRead = false;
            this.secureReadable.setAuthAttrSet(this.authAttrSet);
        }
        return this.authAttrSet;
    }

    public AttributeTable getAuthAttrs() throws IOException {
        ASN1Set aSN1Set;
        if (this.authAttrs == null && this.authAttrNotRead && (aSN1Set = this.getAuthAttrSet()) != null) {
            this.authAttrs = new AttributeTable(aSN1Set);
        }
        return this.authAttrs;
    }

    public AttributeTable getUnauthAttrs() throws IOException {
        if (this.unauthAttrs == null && this.unauthAttrNotRead) {
            this.unauthAttrNotRead = false;
            this.unauthAttrs = CMSUtils.getAttributesTable(this.authData.getUnauthAttrs());
        }
        return this.unauthAttrs;
    }

    public byte[] getContentDigest() {
        if (this.authAttrs != null) {
            return ASN1OctetString.getInstance(this.authAttrs.get(CMSAttributes.messageDigest).getAttrValues().getObjectAt(0)).getOctets();
        }
        return null;
    }
}

