/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.apache.commons.collections.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.ozone.shaded.org.apache.commons.collections.Factory;
import org.apache.hadoop.ozone.shaded.org.apache.commons.collections.Transformer;
import org.apache.hadoop.ozone.shaded.org.apache.commons.collections.functors.FactoryTransformer;
import org.apache.hadoop.ozone.shaded.org.apache.commons.collections.map.AbstractMapDecorator;

public class LazyMap
extends AbstractMapDecorator
implements Map,
Serializable {
    private static final long serialVersionUID = 7990956402564206740L;
    protected final Transformer factory;

    public static Map decorate(Map map, Factory factory2) {
        return new LazyMap(map, factory2);
    }

    public static Map decorate(Map map, Transformer factory2) {
        return new LazyMap(map, factory2);
    }

    protected LazyMap(Map map, Factory factory2) {
        super(map);
        if (factory2 == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.factory = FactoryTransformer.getInstance(factory2);
    }

    protected LazyMap(Map map, Transformer factory2) {
        super(map);
        if (factory2 == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.factory = factory2;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.map);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = (Map)in.readObject();
    }

    public Object get(Object key) {
        if (!this.map.containsKey(key)) {
            Object value = this.factory.transform(key);
            this.map.put(key, value);
            return value;
        }
        return this.map.get(key);
    }
}

