/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.opentracing.propagation;

import java.nio.ByteBuffer;
import org.apache.hadoop.ozone.shaded.io.opentracing.propagation.BinaryExtract;
import org.apache.hadoop.ozone.shaded.io.opentracing.propagation.BinaryInject;

public final class BinaryAdapters {
    private BinaryAdapters() {
    }

    public static BinaryExtract extractionCarrier(ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        return new BinaryExtractAdapter(buffer);
    }

    public static BinaryInject injectionCarrier(ByteBuffer buffer) {
        return new BinaryInjectAdapter(buffer);
    }

    static class BinaryInjectAdapter
    implements BinaryInject {
        ByteBuffer buffer;

        public BinaryInjectAdapter(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public ByteBuffer injectionBuffer(int length) {
            if (length < 1) {
                throw new IllegalArgumentException("length needs to be larger than 0");
            }
            if (length > this.buffer.remaining()) {
                throw new AssertionError((Object)"length is larger than the backing ByteBuffer remaining length");
            }
            this.buffer.limit(this.buffer.position() + length);
            return this.buffer;
        }
    }

    static class BinaryExtractAdapter
    implements BinaryExtract {
        ByteBuffer buffer;

        public BinaryExtractAdapter(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public ByteBuffer extractionBuffer() {
            return this.buffer;
        }
    }
}

