/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.clock;

import java.lang.reflect.Method;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.clock.Clock;

final class MicrosAccurateClock
implements Clock {
    static final Clock INSTANCE = new MicrosAccurateClock();
    private static final Method NOW;
    private static final Object EPOCH;
    private static final Object CHRONO_UNIT_MICROS;
    private static final Method CHRONO_UNIT_BETWEEN;

    @Override
    public long currentTimeMicros() {
        try {
            Object now = NOW.invoke(null, new Object[0]);
            return (Long)CHRONO_UNIT_BETWEEN.invoke(CHRONO_UNIT_MICROS, EPOCH, now);
        }
        catch (Exception x) {
            throw new IllegalStateException("Could not acquire current microseconds accurate timestamp", x);
        }
    }

    @Override
    public long currentNanoTicks() {
        return System.nanoTime();
    }

    @Override
    public boolean isMicrosAccurate() {
        return true;
    }

    private MicrosAccurateClock() {
    }

    static {
        try {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Class<?> instant = classLoader.loadClass("java.time.Instant");
            NOW = instant.getMethod("now", new Class[0]);
            EPOCH = instant.getField("EPOCH").get(null);
            Class<?> chronoUnit = classLoader.loadClass("java.time.temporal.ChronoUnit");
            CHRONO_UNIT_MICROS = chronoUnit.getField("MICROS").get(null);
            Class<?> temporal = classLoader.loadClass("java.time.temporal.Temporal");
            CHRONO_UNIT_BETWEEN = chronoUnit.getMethod("between", temporal, temporal);
        }
        catch (Exception x) {
            throw new IllegalStateException("Could not setup microseconds accurate time supplier", x);
        }
    }
}

