/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.om.ha.HadoopRpcOMFailoverProxyProvider;
import org.apache.hadoop.ozone.om.helpers.OMNodeDetails;
import org.apache.hadoop.ozone.om.protocol.OMAdminProtocol;
import org.apache.hadoop.ozone.om.protocol.OMConfiguration;
import org.apache.hadoop.ozone.om.protocolPB.OMAdminProtocolPB;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerAdminProtocolProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OMAdminProtocolClientSideImpl
implements OMAdminProtocol {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private static final Logger LOG = LoggerFactory.getLogger(OMAdminProtocolClientSideImpl.class);
    private final OMAdminProtocolPB rpcProxy;
    private final String omPrintInfo;

    private OMAdminProtocolClientSideImpl(OMAdminProtocolPB proxy, String printInfo) {
        this.rpcProxy = proxy;
        this.omPrintInfo = printInfo;
    }

    public static OMAdminProtocolClientSideImpl createProxyForSingleOM(OzoneConfiguration conf, UserGroupInformation ugi, OMNodeDetails omNodeDetails) throws IOException {
        RPC.setProtocolEngine((Configuration)OzoneConfiguration.of(conf), OMAdminProtocolPB.class, ProtobufRpcEngine.class);
        int maxRetries = conf.getInt("ozone.om.admin.protocol.max.retries", 20);
        long waitBetweenRetries = conf.getLong("ozone.om.admin.protocol.wait.between.retries", 1000L);
        RetryPolicy connectionRetryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)maxRetries, (long)waitBetweenRetries, (TimeUnit)TimeUnit.MILLISECONDS);
        Configuration hadoopConf = LegacyHadoopConfigurationSource.asHadoopConfiguration(conf);
        OMAdminProtocolPB proxy = (OMAdminProtocolPB)RPC.getProtocolProxy(OMAdminProtocolPB.class, (long)RPC.getProtocolVersion(OMAdminProtocolPB.class), (InetSocketAddress)omNodeDetails.getRpcAddress(), (UserGroupInformation)ugi, (Configuration)hadoopConf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)hadoopConf), (int)((int)OmUtils.getOMClientRpcTimeOut(conf)), (RetryPolicy)connectionRetryPolicy).getProxy();
        RetryPolicy retryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)10, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        OMAdminProtocolPB rpcProxy = (OMAdminProtocolPB)RetryProxy.create(OMAdminProtocolPB.class, (Object)proxy, (RetryPolicy)retryPolicy);
        return new OMAdminProtocolClientSideImpl(rpcProxy, omNodeDetails.getOMPrintInfo());
    }

    public static OMAdminProtocolClientSideImpl createProxyForOMHA(OzoneConfiguration conf, UserGroupInformation ugi, String omServiceId) throws IOException {
        RPC.setProtocolEngine((Configuration)OzoneConfiguration.of(conf), OMAdminProtocolPB.class, ProtobufRpcEngine.class);
        HadoopRpcOMFailoverProxyProvider<OMAdminProtocolPB> omFailoverProxyProvider = new HadoopRpcOMFailoverProxyProvider<OMAdminProtocolPB>(conf, ugi, omServiceId, OMAdminProtocolPB.class);
        int maxFailovers = conf.getInt("ozone.om.admin.protocol.max.retries", 20) * omFailoverProxyProvider.getOMProxies().size();
        OMAdminProtocolPB retryProxy = (OMAdminProtocolPB)RetryProxy.create(OMAdminProtocolPB.class, omFailoverProxyProvider, (RetryPolicy)omFailoverProxyProvider.getRetryPolicy(maxFailovers));
        List<OMNodeDetails> allOMNodeDetails = OmUtils.getAllOMHAAddresses(conf, omServiceId, false);
        return new OMAdminProtocolClientSideImpl(retryProxy, OmUtils.getOMAddressListPrintString(allOMNodeDetails));
    }

    @Override
    public OMConfiguration getOMConfiguration() throws IOException {
        try {
            OzoneManagerAdminProtocolProtos.OMConfigurationResponse getConfigResponse = this.rpcProxy.getOMConfiguration(NULL_RPC_CONTROLLER, OzoneManagerAdminProtocolProtos.OMConfigurationRequest.newBuilder().build());
            OMConfiguration.Builder omMedatataBuilder = new OMConfiguration.Builder();
            if (getConfigResponse.getSuccess()) {
                if (getConfigResponse.getNodesInMemoryCount() > 0) {
                    for (OzoneManagerAdminProtocolProtos.OMNodeInfo omNodeInfo : getConfigResponse.getNodesInMemoryList()) {
                        omMedatataBuilder.addToNodesInMemory(OMNodeDetails.getFromProtobuf(omNodeInfo));
                    }
                }
                if (getConfigResponse.getNodesInNewConfCount() > 0) {
                    for (OzoneManagerAdminProtocolProtos.OMNodeInfo omNodeInfo : getConfigResponse.getNodesInNewConfList()) {
                        omMedatataBuilder.addToNodesInNewConf(OMNodeDetails.getFromProtobuf(omNodeInfo));
                    }
                }
            }
            return omMedatataBuilder.build();
        }
        catch (ServiceException e) {
            LOG.error("Failed to retrieve configuration of OM {}", (Object)this.omPrintInfo, (Object)e);
            return null;
        }
    }

    @Override
    public void decommission(OMNodeDetails removeOMNode) throws IOException {
        OzoneManagerAdminProtocolProtos.DecommissionOMResponse response;
        OzoneManagerAdminProtocolProtos.DecommissionOMRequest decommOMRequest = OzoneManagerAdminProtocolProtos.DecommissionOMRequest.newBuilder().setNodeId(removeOMNode.getNodeId()).setNodeAddress(removeOMNode.getHostAddress()).build();
        try {
            response = this.rpcProxy.decommission(NULL_RPC_CONTROLLER, decommOMRequest);
        }
        catch (ServiceException e) {
            OMLeaderNotReadyException leaderNotReadyException;
            OMNotLeaderException notLeaderException = HadoopRpcOMFailoverProxyProvider.getNotLeaderException(e);
            if (notLeaderException != null) {
                this.throwException(notLeaderException.getMessage());
            }
            if ((leaderNotReadyException = HadoopRpcOMFailoverProxyProvider.getLeaderNotReadyException(e)) != null) {
                this.throwException(leaderNotReadyException.getMessage());
            }
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (!response.getSuccess()) {
            this.throwException("Request to decommission" + removeOMNode.getOMPrintInfo() + ", sent to " + this.omPrintInfo + " failed with error: " + response.getErrorMsg());
        }
    }

    private void throwException(String errorMsg) throws IOException {
        throw new IOException("Failed to Decommission OM. Error: " + errorMsg);
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy((Object)this.rpcProxy);
    }
}

