/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.PostConstruct;
import org.apache.hadoop.hdds.conf.ReconfigurableConfig;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

@ConfigGroup(prefix="ozone.om")
public class OmConfig
extends ReconfigurableConfig {
    @Config(key="enable.filesystem.paths", defaultValue="false", description="If true, key names will be interpreted as file system paths. '/' will be treated as a special character and paths will be normalized and must follow Unix filesystem path naming conventions. This flag will be helpful when objects created by S3G need to be accessed using OFS/O3Fs. If false, it will fallback to default behavior of Key/MPU create requests where key paths are not normalized and any intermediate directories will not be created or any file checks happens to check filesystem semantics.", tags={ConfigTag.OM, ConfigTag.OZONE})
    private boolean fileSystemPathEnabled;
    @Config(key="server.list.max.size", defaultValue="1000", description="Configuration property to configure the max server side response size for list calls on om.", reconfigurable=true, tags={ConfigTag.OM, ConfigTag.OZONE})
    private long maxListSize;
    @Config(key="user.max.volume", defaultValue="1024", description="The maximum number of volumes a user can have on a cluster.Increasing or decreasing this number has no real impact on ozone cluster. This is defined only for operational purposes. Only an administrator can create a volume, once a volume is created there are no restrictions on the number of buckets or keys inside each bucket a user can create.", tags={ConfigTag.OM, ConfigTag.MANAGEMENT})
    private int maxUserVolumeCount;

    public boolean isFileSystemPathEnabled() {
        return this.fileSystemPathEnabled;
    }

    public void setFileSystemPathEnabled(boolean newValue) {
        this.fileSystemPathEnabled = newValue;
    }

    public long getMaxListSize() {
        return this.maxListSize;
    }

    public void setMaxListSize(long newValue) {
        this.maxListSize = newValue;
        this.validate();
    }

    public int getMaxUserVolumeCount() {
        return this.maxUserVolumeCount;
    }

    public void setMaxUserVolumeCount(int newValue) {
        this.maxUserVolumeCount = newValue;
        this.validate();
    }

    @PostConstruct
    public void validate() {
        if (this.maxListSize <= 0L) {
            this.maxListSize = 1000L;
        }
        Preconditions.checkArgument(this.maxUserVolumeCount > 0, "ozone.om.user.max.volume value should be greater than zero");
    }

    public OmConfig copy() {
        OmConfig copy = new OmConfig();
        copy.setFrom(this);
        return copy;
    }

    public void setFrom(OmConfig other) {
        this.fileSystemPathEnabled = other.fileSystemPathEnabled;
        this.maxListSize = other.maxListSize;
        this.maxUserVolumeCount = other.maxUserVolumeCount;
    }

    public static final class Defaults {
        public static final boolean ENABLE_FILESYSTEM_PATHS = false;
        public static final long SERVER_LIST_MAX_SIZE = 1000L;
    }

    public static final class Keys {
        public static final String ENABLE_FILESYSTEM_PATHS = "ozone.om.enable.filesystem.paths";
        public static final String SERVER_LIST_MAX_SIZE = "ozone.om.server.list.max.size";
        public static final String USER_MAX_VOLUME = "ozone.om.user.max.volume";
    }
}

