/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Objects;
import java.util.function.Function;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.hadoop.hdds.utils.db.PutToByteBuffer;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class StringCodecBase
implements Codec<String> {
    static final Logger LOG = LoggerFactory.getLogger(StringCodecBase.class);
    private final Charset charset;
    private final boolean fixedLength;
    private final int maxBytesPerChar;

    StringCodecBase(Charset charset) {
        this.charset = charset;
        CharsetEncoder encoder = charset.newEncoder();
        float max = encoder.maxBytesPerChar();
        this.maxBytesPerChar = (int)max;
        if ((float)this.maxBytesPerChar != max) {
            throw new ArithmeticException("Round off error in " + charset + ": maxBytesPerChar = " + max + " is not an integer.");
        }
        this.fixedLength = max == encoder.averageBytesPerChar();
    }

    @Override
    public final Class<String> getTypeClass() {
        return String.class;
    }

    CharsetEncoder newEncoder() {
        return this.charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    CharsetDecoder newDecoder() {
        return this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    public boolean isFixedLength() {
        return this.fixedLength;
    }

    private int getSerializedSizeUpperBound(String s2) {
        return this.maxBytesPerChar * s2.length();
    }

    private <E extends Exception> PutToByteBuffer<E> encode(String string, Integer serializedSize, Function<String, E> newE) {
        return buffer -> {
            CoderResult result = this.newEncoder().encode(CharBuffer.wrap(string), (ByteBuffer)buffer, true);
            if (result.isError()) {
                throw (Exception)newE.apply("Failed to encode with " + this.charset + ": " + result + ", string=" + string);
            }
            int remaining = buffer.flip().remaining();
            if (serializedSize != null && serializedSize != remaining) {
                throw (Exception)newE.apply("Size mismatched: Expected size is " + serializedSize + " but actual size is " + remaining + ", string=" + string);
            }
            return remaining;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String decode(ByteBuffer buffer) {
        Runnable error = null;
        try {
            String string = this.newDecoder().decode(buffer.asReadOnlyBuffer()).toString();
            return string;
        }
        catch (Exception e) {
            error = () -> LOG.warn("Failed to decode buffer with " + this.charset + ", buffer = (hex) " + StringUtils.bytes2Hex(buffer), (Throwable)e);
            String decoded = StringUtils.bytes2String(buffer, this.charset);
            error = () -> LOG.warn("Decode (hex) " + StringUtils.bytes2Hex(buffer, 20) + "\n  Attempt failed : " + this.charset + " (see exception below)\n  Retry succeeded: decoded to " + decoded, (Throwable)e);
            String string = decoded;
            return string;
        }
        finally {
            if (error != null) {
                error.run();
            }
        }
    }

    <E extends Exception> byte[] string2Bytes(String string, Function<String, E> newE) throws E {
        int upperBound = this.getSerializedSizeUpperBound(string);
        Integer serializedSize = this.isFixedLength() ? Integer.valueOf(upperBound) : null;
        PutToByteBuffer<E> encoder = this.encode(string, serializedSize, newE);
        if (serializedSize != null) {
            byte[] array = new byte[serializedSize.intValue()];
            Integer encoded = (Integer)encoder.apply(ByteBuffer.wrap(array));
            Objects.requireNonNull(encoded, "encoded == null");
            Preconditions.assertSame(serializedSize, encoded, "serializedSize");
            return array;
        }
        try (CodecBuffer buffer = CodecBuffer.allocateHeap(upperBound);){
            buffer.putFromSource(encoder);
            byte[] byArray = buffer.getArray();
            return byArray;
        }
    }

    @Override
    public boolean supportCodecBuffer() {
        return true;
    }

    @Override
    public CodecBuffer toCodecBuffer(@Nonnull String object, CodecBuffer.Allocator allocator) throws IOException {
        int upperBound = this.getSerializedSizeUpperBound(object);
        CodecBuffer buffer = (CodecBuffer)allocator.apply(upperBound);
        buffer.putFromSource(this.encode(object, null, IOException::new));
        return buffer;
    }

    @Override
    public String fromCodecBuffer(@Nonnull CodecBuffer buffer) {
        return this.decode(buffer.asReadOnlyByteBuffer());
    }

    @Override
    public byte[] toPersistedFormat(String object) throws IOException {
        return this.string2Bytes(object, IOException::new);
    }

    @Override
    public String fromPersistedFormat(byte[] bytes) {
        return this.decode(ByteBuffer.wrap(bytes));
    }

    @Override
    public String copyObject(String object) {
        return object;
    }
}

