/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import java.math.BigInteger;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.JaegerSpanContext;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.exceptions.EmptyTracerStateStringException;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.exceptions.MalformedTracerStateStringException;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.exceptions.TraceIdOutOfBoundException;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.spi.Codec;
import org.apache.hadoop.ozone.shaded.io.opentracing.propagation.Format;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringCodec
implements Codec<StringBuilder> {
    public static final Logger LOG = LoggerFactory.getLogger(StringCodec.class);
    public static final StringFormat FORMAT = new StringFormat();

    @Override
    public JaegerSpanContext extract(StringBuilder s2) {
        if (s2 == null) {
            throw new EmptyTracerStateStringException();
        }
        String value = s2.toString();
        if (!"".equals(value)) {
            String[] parts = value.split(":");
            if (parts.length != 4) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("MalformedTracerStateString: {}", (Object)value);
                }
                throw new MalformedTracerStateStringException(value);
            }
            String traceId = parts[0];
            if (traceId.length() <= 32 && !traceId.isEmpty()) {
                return new JaegerSpanContext(StringCodec.high(traceId), new BigInteger(traceId, 16).longValue(), new BigInteger(parts[1], 16).longValue(), new BigInteger(parts[2], 16).longValue(), new BigInteger(parts[3], 16).byteValue());
            }
            throw new TraceIdOutOfBoundException("Trace id [" + traceId + "] length is not within 1 and 32");
        }
        throw new EmptyTracerStateStringException();
    }

    @Override
    public void inject(JaegerSpanContext context, StringBuilder string) {
        int intFlag = context.getFlags() & 0xFF;
        string.append(context.getTraceId()).append(":").append(Long.toHexString(context.getSpanId())).append(":").append(Long.toHexString(context.getParentId())).append(":").append(Integer.toHexString(intFlag));
    }

    private static long high(String hexString) {
        if (hexString.length() > 16) {
            int highLength = hexString.length() - 16;
            String highString = hexString.substring(0, highLength);
            return new BigInteger(highString, 16).longValue();
        }
        return 0L;
    }

    public static final class StringFormat
    implements Format<StringBuilder> {
    }
}

