/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeDurationUtil {
    public static final Logger LOG = LoggerFactory.getLogger(TimeDurationUtil.class);

    private TimeDurationUtil() {
    }

    public static long getTimeDurationHelper(String name, String vStr, TimeUnit unit) {
        long millis = TimeDurationUtil.getDuration(name, vStr, unit).toMillis();
        return unit.convert(millis, TimeUnit.MILLISECONDS);
    }

    public static Duration getDuration(String name, String vStr, TimeUnit unit) {
        vStr = vStr.trim();
        ParsedTimeDuration vUnit = ParsedTimeDuration.unitFor(vStr = vStr.toLowerCase());
        if (null == vUnit) {
            LOG.warn("No unit for " + name + "(" + vStr + ") assuming " + (Object)((Object)unit));
            vUnit = ParsedTimeDuration.unitFor(unit);
            if (null == vUnit) {
                throw new IllegalArgumentException("Unexpected unit: " + (Object)((Object)unit));
            }
        } else {
            vStr = vStr.substring(0, vStr.lastIndexOf(vUnit.suffix()));
        }
        long raw = Long.parseLong(vStr);
        return Duration.of(raw, vUnit.temporalUnit());
    }

    static enum ParsedTimeDuration {
        NS{

            @Override
            TimeUnit unit() {
                return TimeUnit.NANOSECONDS;
            }

            @Override
            String suffix() {
                return "ns";
            }

            @Override
            TemporalUnit temporalUnit() {
                return ChronoUnit.NANOS;
            }
        }
        ,
        US{

            @Override
            TimeUnit unit() {
                return TimeUnit.MICROSECONDS;
            }

            @Override
            String suffix() {
                return "us";
            }

            @Override
            TemporalUnit temporalUnit() {
                return ChronoUnit.MICROS;
            }
        }
        ,
        MS{

            @Override
            TimeUnit unit() {
                return TimeUnit.MILLISECONDS;
            }

            @Override
            String suffix() {
                return "ms";
            }

            @Override
            TemporalUnit temporalUnit() {
                return ChronoUnit.MILLIS;
            }
        }
        ,
        S{

            @Override
            TimeUnit unit() {
                return TimeUnit.SECONDS;
            }

            @Override
            String suffix() {
                return "s";
            }

            @Override
            TemporalUnit temporalUnit() {
                return ChronoUnit.SECONDS;
            }
        }
        ,
        M{

            @Override
            TimeUnit unit() {
                return TimeUnit.MINUTES;
            }

            @Override
            String suffix() {
                return "m";
            }

            @Override
            TemporalUnit temporalUnit() {
                return ChronoUnit.MINUTES;
            }
        }
        ,
        H{

            @Override
            TimeUnit unit() {
                return TimeUnit.HOURS;
            }

            @Override
            String suffix() {
                return "h";
            }

            @Override
            TemporalUnit temporalUnit() {
                return ChronoUnit.HOURS;
            }
        }
        ,
        D{

            @Override
            TimeUnit unit() {
                return TimeUnit.DAYS;
            }

            @Override
            String suffix() {
                return "d";
            }

            @Override
            TemporalUnit temporalUnit() {
                return ChronoUnit.DAYS;
            }
        };


        abstract TimeUnit unit();

        abstract String suffix();

        abstract TemporalUnit temporalUnit();

        static ParsedTimeDuration unitFor(String s2) {
            for (ParsedTimeDuration ptd : ParsedTimeDuration.values()) {
                if (!s2.endsWith(ptd.suffix())) continue;
                return ptd;
            }
            return null;
        }

        static ParsedTimeDuration unitFor(TimeUnit unit) {
            for (ParsedTimeDuration ptd : ParsedTimeDuration.values()) {
                if (ptd.unit() != unit) continue;
                return ptd;
            }
            return null;
        }
    }
}

