/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.cli;

import java.util.ServiceLoader;
import java.util.TreeMap;
import org.apache.hadoop.ozone.shaded.picocli.CommandLine;

public interface ExtensibleParentCommand {
    public Class<?> subcommandType();

    public static void addSubcommands(CommandLine cli) {
        Object command = cli.getCommand();
        if (command instanceof ExtensibleParentCommand) {
            ExtensibleParentCommand parentCommand = (ExtensibleParentCommand)command;
            ServiceLoader<?> subcommands = ServiceLoader.load(parentCommand.subcommandType());
            TreeMap<String, CommandLine> sorted2 = new TreeMap<String, CommandLine>();
            for (Object subcommand : subcommands) {
                CommandLine.Command commandAnnotation = subcommand.getClass().getAnnotation(CommandLine.Command.class);
                CommandLine subcommandCommandLine = new CommandLine(subcommand, cli.getFactory());
                sorted2.put(commandAnnotation.name(), subcommandCommandLine);
            }
            sorted2.forEach(cli::addSubcommand);
        }
        for (CommandLine subcommand : cli.getSubcommands().values()) {
            ExtensibleParentCommand.addSubcommands(subcommand);
        }
    }
}

