/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.ozone.OzoneClientAdapter;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.scm.storage.BlockLocationInfo;
import org.apache.hadoop.ozone.om.helpers.LeaseKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LeaseRecoveryClientDNHandler {
    static final Logger LOG = LoggerFactory.getLogger(LeaseRecoveryClientDNHandler.class);

    private LeaseRecoveryClientDNHandler() {
    }

    @Nonnull
    public static List<OmKeyLocationInfo> getOmKeyLocationInfos(LeaseKeyInfo leaseKeyInfo, OzoneClientAdapter adapter, boolean forceRecovery) throws IOException {
        OmKeyLocationInfoGroup keyLatestVersionLocations = leaseKeyInfo.getKeyInfo().getLatestVersionLocations();
        List<OmKeyLocationInfo> keyLocationInfoList = keyLatestVersionLocations.getLocationList();
        OmKeyLocationInfoGroup openKeyLatestVersionLocations = leaseKeyInfo.getOpenKeyInfo().getLatestVersionLocations();
        List<OmKeyLocationInfo> openKeyLocationInfoList = openKeyLatestVersionLocations.getLocationList();
        int openKeyLocationSize = openKeyLocationInfoList.size();
        int keyLocationSize = keyLocationInfoList.size();
        OmKeyLocationInfo openKeyFinalBlock = null;
        BlockLocationInfo openKeyPenultimateBlock = null;
        if (keyLocationSize > 0) {
            OmKeyLocationInfo keyFinalBlock = keyLocationInfoList.get(keyLocationSize - 1);
            if (openKeyLocationSize > 1) {
                openKeyFinalBlock = openKeyLocationInfoList.get(openKeyLocationSize - 1);
                openKeyPenultimateBlock = openKeyLocationInfoList.get(openKeyLocationSize - 2);
            } else if (openKeyLocationSize > 0) {
                openKeyFinalBlock = openKeyLocationInfoList.get(0);
            }
            try {
                if (openKeyLocationSize > keyLocationSize) {
                    openKeyFinalBlock.setLength(adapter.finalizeBlock(openKeyFinalBlock));
                    keyLocationInfoList.add(openKeyFinalBlock);
                }
                if (openKeyPenultimateBlock != null && keyFinalBlock != null && openKeyPenultimateBlock.getLength() != keyFinalBlock.getLength() && openKeyPenultimateBlock.getBlockID().getLocalID() == keyFinalBlock.getBlockID().getLocalID()) {
                    keyFinalBlock.setLength(adapter.finalizeBlock(keyFinalBlock));
                }
                if (keyLocationInfoList.size() == openKeyLocationInfoList.size() && keyFinalBlock != null) {
                    keyFinalBlock.setLength(adapter.finalizeBlock(keyFinalBlock));
                }
            }
            catch (Throwable e) {
                if (e instanceof StorageContainerException && (((StorageContainerException)e).getResult().equals(ContainerProtos.Result.NO_SUCH_BLOCK) || ((StorageContainerException)e).getResult().equals(ContainerProtos.Result.CONTAINER_NOT_FOUND)) && openKeyPenultimateBlock != null && keyFinalBlock != null && openKeyPenultimateBlock.getBlockID().getLocalID() == keyFinalBlock.getBlockID().getLocalID()) {
                    try {
                        keyFinalBlock.setLength(adapter.finalizeBlock(keyFinalBlock));
                    }
                    catch (Throwable exp) {
                        if (!forceRecovery) {
                            throw exp;
                        }
                        LOG.warn("Failed to finalize block. Continue to recover the file since {} is enabled.", (Object)"OZONE.CLIENT.RECOVER.LEASE.FORCE", (Object)exp);
                    }
                }
                if (!forceRecovery) {
                    throw e;
                }
                LOG.warn("Failed to finalize block. Continue to recover the file since {} is enabled.", (Object)"OZONE.CLIENT.RECOVER.LEASE.FORCE", (Object)e);
            }
        }
        return keyLocationInfoList;
    }
}

