/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.ozone.BasicKeyInfo;
import org.apache.hadoop.fs.ozone.BasicRootedOzoneClientAdapterImpl;
import org.apache.hadoop.fs.ozone.FileStatusAdapter;
import org.apache.hadoop.fs.ozone.OzoneClientAdapter;
import org.apache.hadoop.fs.ozone.OzoneClientUtils;
import org.apache.hadoop.fs.ozone.OzoneFSDataStreamOutput;
import org.apache.hadoop.fs.ozone.OzoneFSInputStream;
import org.apache.hadoop.fs.ozone.OzoneFSOutputStream;
import org.apache.hadoop.fs.ozone.Statistic;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.ozone.OFSPath;
import org.apache.hadoop.ozone.OzoneFsServerDefaults;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.SelectorOutputStream;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Function;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.io.opentracing.Span;
import org.apache.hadoop.ozone.shaded.io.opentracing.util.GlobalTracer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;
import org.apache.http.client.utils.URIBuilder;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BasicRootedOzoneFileSystem
extends FileSystem {
    static final Logger LOG = LoggerFactory.getLogger(BasicRootedOzoneFileSystem.class);
    private URI uri;
    private String userName;
    private Path workingDir;
    private OzoneClientAdapter adapter;
    private BasicRootedOzoneClientAdapterImpl adapterImpl;
    private int listingPageSize = 1024;
    private boolean hsyncEnabled = false;
    private boolean isRatisStreamingEnabled = false;
    private int streamingAutoThreshold;
    private static final String URI_EXCEPTION_TEXT = "URL should be one of the following formats: ofs://om-service-id/path/to/key  OR ofs://om-host.example.com/path/to/key  OR ofs://om-host.example.com:5678/path/to/key";
    private static final int PATH_DEPTH_TO_BUCKET = 2;
    private OzoneConfiguration ozoneConfiguration;

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.listingPageSize = conf.getInt("ozone.fs.listing.page.size", 1024);
        this.listingPageSize = OzoneClientUtils.limitValue(this.listingPageSize, "ozone.fs.listing.page.size", 5000);
        this.isRatisStreamingEnabled = conf.getBoolean("ozone.fs.datastream.enabled", false);
        this.streamingAutoThreshold = (int)OzoneConfiguration.of(conf).getStorageSize("ozone.fs.datastream.auto.threshold", "4MB", StorageUnit.BYTES);
        this.setConf(conf);
        Preconditions.checkNotNull(name.getScheme(), "No scheme provided in %s", (Object)name);
        Preconditions.checkArgument(this.getScheme().equals(name.getScheme()), "Invalid scheme provided in %s", (Object)name);
        String authority = name.getAuthority();
        if (authority == null) {
            throw new IllegalArgumentException(URI_EXCEPTION_TEXT);
        }
        int omPort = -1;
        String[] parts = authority.split(":");
        if (parts.length > 2) {
            throw new IllegalArgumentException(URI_EXCEPTION_TEXT);
        }
        String omHostOrServiceId = parts[0];
        if (parts.length == 2) {
            try {
                omPort = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(URI_EXCEPTION_TEXT);
            }
        }
        try {
            this.uri = new URIBuilder().setScheme("ofs").setHost(authority).build();
            LOG.trace("Ozone URI for OFS initialization is " + this.uri);
            ConfigurationSource source2 = this.getConfSource();
            this.hsyncEnabled = OzoneFSUtils.canEnableHsync(source2, true);
            LOG.debug("hsyncEnabled = {}", (Object)this.hsyncEnabled);
            this.adapter = this.createAdapter(source2, omHostOrServiceId, omPort);
            this.adapterImpl = (BasicRootedOzoneClientAdapterImpl)this.adapter;
            try {
                this.userName = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException e) {
                this.userName = "hdfs";
            }
            this.workingDir = new Path("/user", this.userName).makeQualified(this.uri, this.workingDir);
        }
        catch (URISyntaxException ue) {
            String msg = "Invalid Ozone endpoint " + name;
            LOG.error(msg, (Throwable)ue);
            throw new IOException(msg, ue);
        }
        this.ozoneConfiguration = OzoneConfiguration.of(this.getConfSource());
    }

    protected OzoneClientAdapter createAdapter(ConfigurationSource conf, String omHost, int omPort) throws IOException {
        return new BasicRootedOzoneClientAdapterImpl(omHost, omPort, conf);
    }

    protected boolean isHsyncEnabled() {
        return this.hsyncEnabled;
    }

    public void close() throws IOException {
        try {
            this.adapter.close();
        }
        finally {
            super.close();
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public String getScheme() {
        return "ofs";
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_OPEN, 1L);
        this.statistics.incrementReadOps(1);
        LOG.trace("open() path: {}", (Object)path);
        String key = this.pathToKey(path);
        return TracingUtil.executeInNewSpan("ofs open", () -> {
            Span span = GlobalTracer.get().activeSpan();
            span.setTag("path", key);
            return new FSDataInputStream(this.createFSInputStream(this.adapter.readFile(key)));
        });
    }

    protected InputStream createFSInputStream(InputStream inputStream2) {
        return new OzoneFSInputStream(inputStream2, this.statistics);
    }

    protected void incrementCounter(Statistic statistic) {
        this.incrementCounter(statistic, 1L);
    }

    protected void incrementCounter(Statistic statistic, long count) {
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        LOG.trace("create() path:{}", (Object)f);
        this.incrementCounter(Statistic.INVOCATION_CREATE, 1L);
        this.statistics.incrementWriteOps(1);
        String key = this.pathToKey(f);
        return TracingUtil.executeInNewSpan("ofs create", () -> this.createOutputStream(key, replication, overwrite, true));
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_CREATE_NON_RECURSIVE, 1L);
        this.statistics.incrementWriteOps(1);
        String key = this.pathToKey(path);
        return TracingUtil.executeInNewSpan("ofs createNonRecursive", () -> this.createOutputStream(key, replication, flags.contains(CreateFlag.OVERWRITE), false));
    }

    private OutputStream selectOutputStream(String key, short replication, boolean overwrite, boolean recursive, int byteWritten) throws IOException {
        return this.isRatisStreamingEnabled && byteWritten > this.streamingAutoThreshold ? this.createFSDataStreamOutput(this.adapter.createStreamFile(key, replication, overwrite, recursive)) : this.createFSOutputStream(this.adapter.createFile(key, replication, overwrite, recursive));
    }

    private FSDataOutputStream createOutputStream(String key, short replication, boolean overwrite, boolean recursive) throws IOException {
        if (this.isRatisStreamingEnabled) {
            CheckedFunction selector = byteWritten -> this.selectOutputStream(key, replication, overwrite, recursive, (int)byteWritten);
            return new FSDataOutputStream(new SelectorOutputStream<OutputStream>(this.streamingAutoThreshold, selector), this.statistics);
        }
        return new FSDataOutputStream((OutputStream)this.createFSOutputStream(this.adapter.createFile(key, replication, overwrite, recursive)), this.statistics);
    }

    protected OzoneFSOutputStream createFSOutputStream(OzoneFSOutputStream outputStream2) {
        return outputStream2;
    }

    protected OzoneFSDataStreamOutput createFSDataStreamOutput(OzoneFSDataStreamOutput outputDataStream) {
        return outputDataStream;
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("append() Not implemented by the " + ((Object)((Object)this)).getClass().getSimpleName() + " FileSystem implementation");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return TracingUtil.executeInNewSpan("ofs rename", () -> this.renameInSpan(src, dst));
    }

    private boolean renameInSpan(Path src, Path dst) throws IOException {
        FileStatus dstStatus;
        FileStatus srcStatus;
        Path dstParent;
        Span span = GlobalTracer.get().activeSpan();
        span.setTag("src", src.toString()).setTag("dst", dst.toString());
        this.incrementCounter(Statistic.INVOCATION_RENAME, 1L);
        this.statistics.incrementWriteOps(1);
        if (src.equals((Object)dst)) {
            return true;
        }
        LOG.trace("rename() from: {} to: {}", (Object)src, (Object)dst);
        if (src.isRoot()) {
            LOG.trace("Cannot rename the root of a filesystem");
            return false;
        }
        OFSPath ofsSrc = new OFSPath(src, this.ozoneConfiguration);
        OFSPath ofsDst = new OFSPath(dst, this.ozoneConfiguration);
        if (!ofsSrc.isInSameBucketAs(ofsDst)) {
            throw new IOException("Cannot rename a key to a different bucket");
        }
        OzoneBucket bucket = this.adapterImpl.getBucket(ofsSrc, false);
        if (bucket.getBucketLayout().isFileSystemOptimized()) {
            return this.renameFSO(bucket, ofsSrc, ofsDst);
        }
        for (dstParent = dst.getParent(); dstParent != null && !src.equals((Object)dstParent); dstParent = dstParent.getParent()) {
        }
        Preconditions.checkArgument(dstParent == null, "Cannot rename a directory to its own subdirectory");
        try {
            srcStatus = this.getFileStatus(src);
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        try {
            dstStatus = this.getFileStatus(dst);
        }
        catch (FileNotFoundException fnde) {
            dstStatus = null;
        }
        if (dstStatus == null) {
            dstStatus = this.getFileStatus(dst.getParent());
            if (!dstStatus.isDirectory()) {
                throw new IOException(String.format("Failed to rename %s to %s, %s is a file", src, dst, dst.getParent()));
            }
        } else {
            if (srcStatus.getPath().equals((Object)dstStatus.getPath())) {
                return !srcStatus.isDirectory();
            }
            if (dstStatus.isDirectory()) {
                FileStatus[] statuses;
                dst = new Path(dst, src.getName());
                try {
                    statuses = this.listStatus(dst);
                }
                catch (FileNotFoundException fnde) {
                    statuses = null;
                }
                if (statuses != null && statuses.length > 0) {
                    LOG.warn("Failed to rename {} to {}, file already exists or not empty!", (Object)src, (Object)dst);
                    return false;
                }
            } else {
                LOG.warn("Failed to rename {} to {}, file already exists!", (Object)src, (Object)dst);
                return false;
            }
        }
        if (srcStatus.isDirectory() && dst.toString().startsWith(src.toString() + "/")) {
            LOG.trace("Cannot rename a directory to a subdirectory of self");
            return false;
        }
        RenameIterator iterator2 = new RenameIterator(src, dst);
        boolean result = iterator2.iterate();
        if (result) {
            this.createFakeParentDirectory(src);
        }
        return result;
    }

    private boolean renameFSO(OzoneBucket bucket, OFSPath srcPath, OFSPath dstPath) throws IOException {
        String srcKeyPath = srcPath.getNonKeyPathNoPrefixDelim() + "/" + srcPath.getKeyName();
        String dstKeyPath = dstPath.getNonKeyPathNoPrefixDelim() + "/" + dstPath.getKeyName();
        try {
            this.adapterImpl.rename(bucket, srcKeyPath, dstKeyPath);
        }
        catch (OMException ome) {
            LOG.error("rename key failed: {}. source:{}, destin:{}", new Object[]{ome.getMessage(), srcKeyPath, dstKeyPath});
            if (OMException.ResultCodes.KEY_ALREADY_EXISTS == ome.getResult() || OMException.ResultCodes.KEY_RENAME_ERROR == ome.getResult() || OMException.ResultCodes.KEY_NOT_FOUND == ome.getResult()) {
                return false;
            }
            throw ome;
        }
        return true;
    }

    @Deprecated
    protected void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        boolean hasMoveToTrash = false;
        if (options != null) {
            for (Options.Rename option : options) {
                if (option != Options.Rename.TO_TRASH) continue;
                hasMoveToTrash = true;
                break;
            }
        }
        if (!hasMoveToTrash) {
            super.rename(src, dst, options);
        } else {
            this.rename(src, dst);
        }
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        String snapshot = TracingUtil.executeInNewSpan("ofs createSnapshot", () -> this.getAdapter().createSnapshot(this.pathToKey(path), snapshotName));
        return new Path(OzoneFSUtils.trimPathToDepth(path, 2), ".snapshot/" + snapshot);
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.getAdapter().renameSnapshot(this.pathToKey(path), snapshotOldName, snapshotNewName);
    }

    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        TracingUtil.executeInNewSpan("ofs deleteSnapshot", () -> this.adapter.deleteSnapshot(this.pathToKey(path), snapshotName));
    }

    private boolean innerDelete(Path f, boolean recursive) throws IOException {
        LOG.trace("delete() path:{} recursive:{}", (Object)f, (Object)recursive);
        try {
            OzoneListingIterator iterator2 = new DeleteIteratorFactory(f, recursive).getDeleteIterator();
            return iterator2.iterate();
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Couldn't delete {} - does not exist", (Object)f);
            }
            return false;
        }
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return TracingUtil.executeInNewSpan("ofs delete", () -> this.deleteInSpan(f, recursive));
    }

    private boolean deleteInSpan(Path f, boolean recursive) throws IOException {
        boolean result;
        FileStatus status;
        this.incrementCounter(Statistic.INVOCATION_DELETE, 1L);
        this.statistics.incrementWriteOps(1);
        LOG.debug("Delete path {} - recursive {}", (Object)f, (Object)recursive);
        String key = this.pathToKey(f);
        OFSPath ofsPath = new OFSPath(key, this.ozoneConfiguration);
        if (ofsPath.isRoot()) {
            LOG.warn("delete: OFS does not support rm root. To wipe the cluster, please re-init OM instead.");
            return false;
        }
        if (ofsPath.isVolume()) {
            if (recursive) {
                LOG.warn("Recursive volume delete using ofs is not supported");
                throw new IOException("Recursive volume delete using ofs is not supported. Instead use 'ozone sh volume delete -r o3://<OM_SERVICE_ID>/<Volume_URI>' command");
            }
            return this.deleteVolume(f, ofsPath);
        }
        if (ofsPath.isBucket()) {
            return this.deleteBucket(f, recursive, ofsPath);
        }
        try {
            status = this.getFileStatus(f);
        }
        catch (FileNotFoundException ex) {
            LOG.warn("delete: Path does not exist: {}", (Object)f);
            return false;
        }
        if (status.isDirectory()) {
            LOG.debug("delete: Path is a directory: {}", (Object)f);
            OzoneBucket bucket = this.adapterImpl.getBucket(ofsPath, false);
            if (bucket.getBucketLayout().isFileSystemOptimized()) {
                String ofsKeyPath = ofsPath.getNonKeyPathNoPrefixDelim() + "/" + ofsPath.getKeyName();
                return this.adapterImpl.deleteObject(ofsKeyPath, recursive);
            }
            result = this.innerDelete(f, recursive);
        } else {
            LOG.debug("delete: Path is a file: {}", (Object)f);
            result = this.adapter.deleteObject(key);
        }
        if (result) {
            this.createFakeParentDirectory(f);
        }
        return result;
    }

    private boolean deleteBucket(Path f, boolean recursive, OFSPath ofsPath) throws IOException {
        OzoneBucket bucket;
        try {
            bucket = this.adapterImpl.getBucket(ofsPath, false);
        }
        catch (OMException ex) {
            if (ex.getResult() != OMException.ResultCodes.BUCKET_NOT_FOUND && ex.getResult() != OMException.ResultCodes.VOLUME_NOT_FOUND) {
                LOG.error("OMException while getting bucket information, considered it as false", (Throwable)ex);
            }
            return false;
        }
        catch (Exception ex) {
            LOG.error("Exception while getting bucket information, considered it as false", (Throwable)ex);
            return false;
        }
        try {
            this.getFileStatus(f);
        }
        catch (FileNotFoundException ex) {
            if (bucket.isLink()) {
                this.deleteBucketFromVolume(f, bucket);
                return true;
            }
            LOG.warn("delete: Path does not exist: {}", (Object)f);
            return false;
        }
        boolean handleTrailingSlash = f.toString().endsWith("/");
        if (bucket.isLink() && !handleTrailingSlash) {
            this.deleteBucketFromVolume(f, bucket);
            return true;
        }
        boolean result = this.innerDelete(f, recursive);
        if (!handleTrailingSlash) {
            this.deleteBucketFromVolume(f, bucket);
        }
        return result;
    }

    private void deleteBucketFromVolume(Path f, OzoneBucket bucket) throws IOException {
        OzoneVolume volume = this.adapterImpl.getObjectStore().getVolume(bucket.getVolumeName());
        try {
            volume.deleteBucket(bucket.getName());
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_EMPTY) {
                throw new PathIsNotEmptyDirectoryException(f.toString());
            }
            throw ex;
        }
    }

    private boolean deleteVolume(Path f, OFSPath ofsPath) throws IOException {
        try {
            this.getFileStatus(f);
        }
        catch (FileNotFoundException ex) {
            LOG.warn("delete: Path does not exist: {}", (Object)f);
            return false;
        }
        String volumeName = ofsPath.getVolumeName();
        try {
            this.adapterImpl.getObjectStore().deleteVolume(volumeName);
            return true;
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.VOLUME_NOT_EMPTY) {
                throw new PathIsNotEmptyDirectoryException(f.toString());
            }
            throw ex;
        }
    }

    private boolean isFSObucket(String volumeName, String bucketName) throws IOException {
        OzoneVolume volume = this.adapterImpl.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = volume.getBucket(bucketName);
        return bucket.getBucketLayout().isFileSystemOptimized();
    }

    private void createFakeParentDirectory(Path f) throws IOException {
        Path parent = f.getParent();
        if (parent != null && !parent.isRoot()) {
            this.createFakeDirectoryIfNecessary(parent);
        }
    }

    private void createFakeDirectoryIfNecessary(Path f) throws IOException {
        String key = this.pathToKey(f);
        if (!key.isEmpty() && !this.o3Exists(f)) {
            LOG.debug("Creating new fake directory at {}", (Object)f);
            String dirKey = this.addTrailingSlashIfNeeded(key);
            this.adapter.createDirectory(dirKey);
        }
    }

    private boolean o3Exists(Path f) throws IOException {
        Path path = this.makeQualified(f);
        try {
            this.getFileStatus(path);
            return true;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        return TracingUtil.executeInNewSpan("ofs listStatus", () -> this.convertFileStatusArr(this.listStatusAdapter(f, true)));
    }

    private FileStatus[] convertFileStatusArr(List<FileStatusAdapter> adapterArr) {
        FileStatus[] fileStatuses = new FileStatus[adapterArr.size()];
        int index = 0;
        for (FileStatusAdapter statusAdapter : adapterArr) {
            fileStatuses[index++] = this.convertFileStatus(statusAdapter);
        }
        return fileStatuses;
    }

    private List<FileStatusAdapter> listStatusAdapter(Path f, boolean lite) throws IOException {
        int entriesAdded;
        this.incrementCounter(Statistic.INVOCATION_LIST_STATUS, 1L);
        this.statistics.incrementReadOps(1);
        LOG.trace("listStatus() path:{}", (Object)f);
        int numEntries = this.listingPageSize;
        LinkedList<FileStatusAdapter> statuses = new LinkedList<FileStatusAdapter>();
        String startPath = "";
        do {
            List<FileStatusAdapter> tmpStatusList = this.adapter.listStatus(this.pathToKey(f), false, startPath, numEntries, this.uri, this.workingDir, this.getUsername(), lite);
            entriesAdded = 0;
            if (tmpStatusList.isEmpty()) continue;
            if (startPath.isEmpty() || !statuses.getLast().getPath().toString().equals(tmpStatusList.get(0).getPath().toString())) {
                statuses.addAll(tmpStatusList);
                entriesAdded += tmpStatusList.size();
            } else {
                statuses.addAll(tmpStatusList.subList(1, tmpStatusList.size()));
                entriesAdded += tmpStatusList.size() - 1;
            }
            startPath = this.pathToKey(statuses.getLast().getPath());
        } while (entriesAdded > 0);
        return statuses;
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public Path getHomeDirectory() {
        return this.makeQualified(new Path("/user/" + this.userName));
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        return TracingUtil.executeInNewSpan("ofs getDelegationToken", () -> this.adapter.getDelegationToken(renewer));
    }

    public String getCanonicalServiceName() {
        return this.adapter.getCanonicalServiceName();
    }

    public String getUsername() {
        return this.userName;
    }

    public Path getTrashRoot(Path path) {
        OFSPath ofsPath = new OFSPath(path, this.ozoneConfiguration);
        return this.makeQualified(ofsPath.getTrashRoot());
    }

    public Collection<FileStatus> getTrashRoots(boolean allUsers) {
        return this.adapterImpl.getTrashRoots(allUsers, this);
    }

    private boolean mkdir(Path path) throws IOException {
        return this.adapter.createDirectory(this.pathToKey(path));
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_MKDIRS);
        LOG.trace("mkdir() path:{} ", (Object)f);
        String key = this.pathToKey(f);
        if (this.isEmpty(key)) {
            return false;
        }
        return TracingUtil.executeInNewSpan("ofs mkdirs", () -> this.mkdir(f));
    }

    public long getDefaultBlockSize() {
        return (long)this.getConfSource().getStorageSize("ozone.scm.block.size", "256MB", StorageUnit.BYTES);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return TracingUtil.executeInNewSpan("ofs getFileStatus", () -> this.convertFileStatus(this.getFileStatusAdapter(f)));
    }

    public FileStatusAdapter getFileStatusAdapter(Path f) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_GET_FILE_STATUS, 1L);
        this.statistics.incrementReadOps(1);
        LOG.trace("getFileStatus() path:{}", (Object)f);
        Path qualifiedPath = f.makeQualified(this.uri, this.workingDir);
        String key = this.pathToKey(qualifiedPath);
        if (key.equals("NONE")) {
            throw new FileNotFoundException("File not found. path /NONE.");
        }
        FileStatusAdapter fileStatus = null;
        try {
            fileStatus = this.adapter.getFileStatus(key, this.uri, qualifiedPath, this.getUsername());
        }
        catch (IOException e) {
            OMException ex;
            if (e instanceof OMException && ((ex = (OMException)e).getResult().equals((Object)OMException.ResultCodes.KEY_NOT_FOUND) || ex.getResult().equals((Object)OMException.ResultCodes.BUCKET_NOT_FOUND) || ex.getResult().equals((Object)OMException.ResultCodes.VOLUME_NOT_FOUND))) {
                throw new FileNotFoundException("File not found. path:" + f);
            }
            throw e;
        }
        return fileStatus;
    }

    public BlockLocation[] getFileBlockLocations(FileStatus fileStatus, long start, long len) throws IOException {
        if (fileStatus instanceof LocatedFileStatus) {
            return ((LocatedFileStatus)fileStatus).getBlockLocations();
        }
        return super.getFileBlockLocations(fileStatus, start, len);
    }

    public short getDefaultReplication() {
        return this.adapter.getDefaultReplication();
    }

    public OzoneFsServerDefaults getServerDefaults() throws IOException {
        return this.adapter.getServerDefaults();
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_COPY_FROM_LOCAL_FILE);
        super.copyFromLocalFile(delSrc, overwrite, srcs, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_COPY_FROM_LOCAL_FILE);
        super.copyFromLocalFile(delSrc, overwrite, src, dst);
    }

    public boolean exists(Path f) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_EXISTS);
        return super.exists(f);
    }

    public FileChecksum getFileChecksum(Path f, long length) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_GET_FILE_CHECKSUM);
        String key = this.pathToKey(f);
        return TracingUtil.executeInNewSpan("ofs getFileChecksum", () -> this.adapter.getFileChecksum(key, length));
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_GLOB_STATUS);
        return super.globStatus(pathPattern);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_GLOB_STATUS);
        return super.globStatus(pathPattern, filter);
    }

    public boolean isDirectory(Path f) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_IS_DIRECTORY);
        return super.isDirectory(f);
    }

    public boolean isFile(Path f) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_IS_FILE);
        return super.isFile(f);
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_LIST_FILES);
        return super.listFiles(f, recursive);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_LIST_LOCATED_STATUS);
        return new OzoneFileStatusIterator<LocatedFileStatus>(f, stat -> stat instanceof LocatedFileStatus ? (LocatedFileStatus)stat : new LocatedFileStatus(stat, null), false);
    }

    public RemoteIterator<FileStatus> listStatusIterator(Path f) throws IOException {
        OFSPath ofsPath = new OFSPath(f, this.ozoneConfiguration);
        if (ofsPath.isRoot() || ofsPath.isVolume()) {
            LOG.warn("Recursive root/volume list using ofs is not supported");
            throw new IOException("Recursive list root/volume using ofs is not supported. Instead use 'ozone sh key list <Volume_URI>' command");
        }
        return new OzoneFileStatusIterator<FileStatus>(f, stat -> stat, true);
    }

    private List<FileStatus> listFileStatus(Path f, String startPath, boolean lite) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_LIST_STATUS, 1L);
        this.statistics.incrementReadOps(1);
        LOG.trace("listFileStatus() path:{}", (Object)f);
        List<FileStatus> statusList = this.adapter.listStatus(this.pathToKey(f), false, startPath, this.listingPageSize, this.uri, this.workingDir, this.getUsername(), lite).stream().map(this::convertFileStatus).collect(Collectors.toList());
        if (!statusList.isEmpty() && !startPath.isEmpty()) {
            statusList.remove(0);
        }
        return statusList;
    }

    public String pathToKey(Path path) {
        String key;
        Objects.requireNonNull(path, "Path can't be null!");
        if (!path.isAbsolute()) {
            path = new Path(this.workingDir, path);
        }
        if (!OzoneFSUtils.isValidName(key = path.toUri().getPath())) {
            throw new InvalidPathException("Invalid path Name " + key);
        }
        key = key.substring(1);
        LOG.trace("path for key: {} is: {}", (Object)key, (Object)path);
        return key;
    }

    private String addTrailingSlashIfNeeded(String key) {
        if (!this.isEmpty(key) && !key.endsWith("/")) {
            return key + "/";
        }
        return key;
    }

    public String toString() {
        return "RootedOzoneFileSystem{URI=" + this.uri + ", workingDir=" + this.workingDir + ", userName=" + this.userName + ", statistics=" + this.statistics + "}";
    }

    public ConfigurationSource getConfSource() {
        Configuration conf = super.getConf();
        ConfigurationSource source2 = conf instanceof OzoneConfiguration ? (ConfigurationSource)conf : new LegacyHadoopConfigurationSource(conf);
        return source2;
    }

    public OzoneClientAdapter getAdapter() {
        return this.adapter;
    }

    public boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public boolean isNumber(String number) {
        try {
            Integer.parseInt(number);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    protected FileStatus constructFileStatus(FileStatusAdapter fileStatusAdapter) {
        return new FileStatus(fileStatusAdapter.getLength(), fileStatusAdapter.isDir(), (int)fileStatusAdapter.getBlockReplication(), fileStatusAdapter.getBlocksize(), fileStatusAdapter.getModificationTime(), fileStatusAdapter.getAccessTime(), new FsPermission(fileStatusAdapter.getPermission()), fileStatusAdapter.getOwner(), fileStatusAdapter.getGroup(), fileStatusAdapter.getSymlink(), fileStatusAdapter.getPath(), false, fileStatusAdapter.isEncrypted(), fileStatusAdapter.isErasureCoded());
    }

    FileStatus convertFileStatus(FileStatusAdapter fileStatusAdapter) {
        FileStatus fileStatus = this.constructFileStatus(fileStatusAdapter);
        BlockLocation[] blockLocations = fileStatusAdapter.getBlockLocations();
        if (blockLocations.length == 0) {
            return fileStatus;
        }
        return new LocatedFileStatus(fileStatus, blockLocations);
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        return TracingUtil.executeInNewSpan("ofs getContentSummary", () -> this.getContentSummaryInSpan(f));
    }

    private ContentSummary getContentSummaryInSpan(Path f) throws IOException {
        FileStatusAdapter status = this.getFileStatusAdapter(f);
        if (status.isFile()) {
            long length = status.getLength();
            long spaceConsumed = status.getDiskConsumed();
            return new ContentSummary.Builder().length(length).fileCount(1L).directoryCount(0L).spaceConsumed(spaceConsumed).build();
        }
        long[] summary = new long[]{0L, 0L, 0L, 1L};
        boolean i = false;
        for (FileStatusAdapter s2 : this.listStatusAdapter(f, true)) {
            long length = s2.getLength();
            long spaceConsumed = s2.getDiskConsumed();
            ContentSummary c = s2.isDir() ? this.getContentSummary(s2.getPath()) : new ContentSummary.Builder().length(length).fileCount(1L).directoryCount(0L).spaceConsumed(spaceConsumed).build();
            summary[0] = summary[0] + c.getLength();
            summary[1] = summary[1] + c.getSpaceConsumed();
            summary[2] = summary[2] + c.getFileCount();
            summary[3] = summary[3] + c.getDirectoryCount();
        }
        return new ContentSummary.Builder().length(summary[0]).fileCount(summary[2]).directoryCount(summary[3]).spaceConsumed(summary[1]).build();
    }

    public boolean supportsSymlinks() {
        return true;
    }

    public Path getLinkTarget(Path f) throws IOException {
        OzoneBucket bucket;
        OFSPath ofsPath = new OFSPath(f, this.ozoneConfiguration);
        if (ofsPath.isBucket() && (bucket = this.adapterImpl.getBucket(ofsPath, false)).isLink()) {
            return new Path("/" + bucket.getSourceVolume() + "/" + bucket.getSourceBucket());
        }
        return f;
    }

    public SnapshotDiffReport getSnapshotDiffReport(Path snapshotDir, String fromSnapshot, String toSnapshot) throws IOException, InterruptedException {
        OFSPath ofsPath = new OFSPath(snapshotDir, this.ozoneConfiguration);
        Preconditions.checkArgument(ofsPath.isBucket(), "Unsupported : Path is not a bucket");
        return this.adapter.getSnapshotDiffReport(snapshotDir, fromSnapshot, toSnapshot);
    }

    public void setTimes(Path f, long mtime, long atime) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_SET_TIMES, 1L);
        this.statistics.incrementWriteOps(1);
        LOG.trace("setTimes() path:{}", (Object)f);
        Path qualifiedPath = this.makeQualified(f);
        String key = this.pathToKey(qualifiedPath);
        if (key.equals("NONE")) {
            throw new FileNotFoundException("File not found. path /NONE.");
        }
        TracingUtil.executeInNewSpan("ofs setTimes", () -> this.adapter.setTimes(key, mtime, atime));
    }

    protected boolean setSafeModeUtil(SafeModeAction action, boolean isChecked) throws IOException {
        if (action == SafeModeAction.GET) {
            this.statistics.incrementReadOps(1);
        } else {
            this.statistics.incrementWriteOps(1);
        }
        LOG.trace("setSafeMode() action:{}", (Object)action);
        return TracingUtil.executeInNewSpan("ofs setSafeMode", () -> this.getAdapter().setSafeMode(action, isChecked));
    }

    private abstract class OzoneListingIterator {
        private final Path path;
        private final FileStatusAdapter status;
        private String pathKey;
        private Iterator<BasicKeyInfo> keyIterator = null;
        private boolean isFSO;

        OzoneListingIterator(Path path, boolean isFSO) throws IOException {
            this.path = path;
            this.status = BasicRootedOzoneFileSystem.this.getFileStatusAdapter(path);
            this.pathKey = BasicRootedOzoneFileSystem.this.pathToKey(path);
            this.isFSO = isFSO;
            if (!isFSO) {
                if (this.status.isDir()) {
                    this.pathKey = BasicRootedOzoneFileSystem.this.addTrailingSlashIfNeeded(this.pathKey);
                }
                this.keyIterator = BasicRootedOzoneFileSystem.this.adapter.listKeys(this.pathKey);
            }
        }

        OzoneListingIterator(Path path) throws IOException {
            this(path, false);
        }

        abstract boolean processKeyPath(List<String> var1) throws IOException;

        boolean iterate() throws IOException {
            LOG.trace("Iterating path: {}", (Object)this.path);
            ArrayList<String> keyPathList = new ArrayList<String>();
            int batchSize = BasicRootedOzoneFileSystem.this.getConf().getInt("ozone.fs.iterate.batch-size", 100);
            if (this.status.isDir()) {
                LOG.trace("Iterating directory: {}", (Object)this.pathKey);
                OFSPath ofsPath = new OFSPath(this.pathKey, BasicRootedOzoneFileSystem.this.ozoneConfiguration);
                String ofsPathPrefix = ofsPath.getNonKeyPathNoPrefixDelim() + "/";
                if (this.isFSO) {
                    List fileStatuses = BasicRootedOzoneFileSystem.this.listStatusAdapter(this.path, true);
                    for (FileStatusAdapter fileStatus : fileStatuses) {
                        String keyName = new OFSPath(fileStatus.getPath().toString(), BasicRootedOzoneFileSystem.this.ozoneConfiguration).getKeyName();
                        keyPathList.add(ofsPathPrefix + keyName);
                    }
                    if (keyPathList.size() >= batchSize) {
                        if (!this.processKeyPath(keyPathList)) {
                            return false;
                        }
                        keyPathList.clear();
                    }
                } else {
                    while (this.keyIterator.hasNext()) {
                        BasicKeyInfo key = this.keyIterator.next();
                        String keyPath = ofsPathPrefix + key.getName();
                        LOG.trace("iterating key path: {}", (Object)keyPath);
                        if (!key.getName().equals("")) {
                            keyPathList.add(keyPath);
                        }
                        if (keyPathList.size() < batchSize) continue;
                        if (!this.processKeyPath(keyPathList)) {
                            return false;
                        }
                        keyPathList.clear();
                    }
                }
                return keyPathList.isEmpty() || this.processKeyPath(keyPathList);
            }
            LOG.trace("iterating file: {}", (Object)this.path);
            keyPathList.add(this.pathKey);
            return this.processKeyPath(keyPathList);
        }

        String getPathKey() {
            return this.pathKey;
        }

        boolean pathIsDirectory() {
            return this.status.isDir();
        }

        FileStatusAdapter getStatus() {
            return this.status;
        }
    }

    private final class OzoneFileStatusIterator<T extends FileStatus>
    implements RemoteIterator<T> {
        private final Function<FileStatus, T> transformFunc;
        private List<FileStatus> thisListing;
        private int i;
        private Path p;
        private T curStat = null;
        private String startPath = "";
        private boolean lite;

        private OzoneFileStatusIterator(Path p, Function<FileStatus, T> transformFunc, boolean lite) throws IOException {
            this.p = p;
            this.lite = lite;
            this.transformFunc = transformFunc;
            this.thisListing = BasicRootedOzoneFileSystem.this.listFileStatus(p, this.startPath, lite);
            if (this.thisListing != null && !this.thisListing.isEmpty()) {
                this.startPath = BasicRootedOzoneFileSystem.this.pathToKey(this.thisListing.get(this.thisListing.size() - 1).getPath());
                LOG.debug("Got {} file status, next start path {}", (Object)this.thisListing.size(), (Object)this.startPath);
            }
            this.i = 0;
        }

        public boolean hasNext() throws IOException {
            while (this.curStat == null && this.hasNextNoFilter()) {
                FileStatus fileStat = this.thisListing.get(this.i++);
                FileStatus next = (FileStatus)this.transformFunc.apply(fileStat);
                this.curStat = next;
            }
            return this.curStat != null;
        }

        private boolean hasNextNoFilter() throws IOException {
            if (this.thisListing == null) {
                return false;
            }
            if (this.i >= this.thisListing.size() && this.startPath != null && !this.thisListing.isEmpty()) {
                this.thisListing = BasicRootedOzoneFileSystem.this.listFileStatus(this.p, this.startPath, this.lite);
                if (this.thisListing == null || this.thisListing.isEmpty()) {
                    return false;
                }
                this.startPath = BasicRootedOzoneFileSystem.this.pathToKey(this.thisListing.get(this.thisListing.size() - 1).getPath());
                LOG.debug("Got {} file status, next start path {}", (Object)this.thisListing.size(), (Object)this.startPath);
                this.i = 0;
            }
            return this.i < this.thisListing.size();
        }

        public T next() throws IOException {
            if (this.hasNext()) {
                T tmp = this.curStat;
                this.curStat = null;
                return tmp;
            }
            throw new NoSuchElementException("No more entry in " + this.p);
        }
    }

    private class DeleteIteratorFactory {
        private Path path;
        private boolean recursive;
        private OFSPath ofsPath;

        DeleteIteratorFactory(Path f, boolean recursive) {
            this.path = f;
            this.recursive = recursive;
            this.ofsPath = new OFSPath(f, BasicRootedOzoneFileSystem.this.ozoneConfiguration);
        }

        OzoneListingIterator getDeleteIterator() throws IOException {
            OzoneListingIterator deleteIterator = this.ofsPath.isBucket() && BasicRootedOzoneFileSystem.this.isFSObucket(this.ofsPath.getVolumeName(), this.ofsPath.getBucketName()) ? new DeleteIteratorWithFSO(this.path, this.recursive) : new DeleteIterator(this.path, this.recursive);
            return deleteIterator;
        }
    }

    private class DeleteIteratorWithFSO
    extends OzoneListingIterator {
        private final OzoneBucket bucket;
        private final BasicRootedOzoneClientAdapterImpl adapterImpl;
        private boolean recursive;
        private Path f;

        DeleteIteratorWithFSO(Path f, boolean recursive) throws IOException {
            super(f, true);
            this.f = f;
            this.recursive = recursive;
            OFSPath ofsPath = new OFSPath(f, BasicRootedOzoneFileSystem.this.ozoneConfiguration);
            this.adapterImpl = (BasicRootedOzoneClientAdapterImpl)BasicRootedOzoneFileSystem.this.adapter;
            this.bucket = this.adapterImpl.getBucket(ofsPath, false);
            LOG.debug("Deleting bucket with name {} is via DeleteIteratorWithFSO.", (Object)this.bucket.getName());
        }

        @Override
        boolean processKeyPath(List<String> keyPathList) throws IOException {
            LOG.trace("Deleting keys: {}", keyPathList);
            boolean succeed = keyPathList.isEmpty();
            if (this.recursive && !succeed) {
                succeed = this.adapterImpl.deleteObjects(keyPathList);
            } else if (!keyPathList.isEmpty()) {
                throw new PathIsNotEmptyDirectoryException(this.f.toString());
            }
            return succeed;
        }
    }

    private class DeleteIterator
    extends OzoneListingIterator {
        private final boolean recursive;
        private final OzoneBucket bucket;
        private final BasicRootedOzoneClientAdapterImpl adapterImpl;

        DeleteIterator(Path f, boolean recursive) throws IOException {
            super(f);
            this.recursive = recursive;
            if (this.getStatus().isDir() && !this.recursive && BasicRootedOzoneFileSystem.this.listStatus(f).length != 0) {
                throw new PathIsNotEmptyDirectoryException(f.toString());
            }
            OFSPath ofsPath = new OFSPath(f, BasicRootedOzoneFileSystem.this.ozoneConfiguration);
            this.adapterImpl = (BasicRootedOzoneClientAdapterImpl)BasicRootedOzoneFileSystem.this.adapter;
            this.bucket = this.adapterImpl.getBucket(ofsPath, false);
        }

        @Override
        boolean processKeyPath(List<String> keyPathList) {
            LOG.trace("Deleting keys: {}", keyPathList);
            boolean succeed = this.adapterImpl.deleteObjects(this.bucket, keyPathList);
            return this.recursive || succeed;
        }
    }

    private class RenameIterator
    extends OzoneListingIterator {
        private final String srcPath;
        private final String dstPath;
        private final OzoneBucket bucket;
        private final BasicRootedOzoneClientAdapterImpl adapterImpl;

        RenameIterator(Path srcPath, Path dstPath) throws IOException {
            super(srcPath);
            this.srcPath = BasicRootedOzoneFileSystem.this.pathToKey(srcPath);
            this.dstPath = BasicRootedOzoneFileSystem.this.pathToKey(dstPath);
            LOG.trace("rename from:{} to:{}", (Object)this.srcPath, (Object)this.dstPath);
            OFSPath ofsPath = new OFSPath(srcPath, BasicRootedOzoneFileSystem.this.ozoneConfiguration);
            this.adapterImpl = (BasicRootedOzoneClientAdapterImpl)BasicRootedOzoneFileSystem.this.adapter;
            this.bucket = this.adapterImpl.getBucket(ofsPath, false);
        }

        @Override
        boolean processKeyPath(List<String> keyPathList) throws IOException {
            for (String keyPath : keyPathList) {
                String newPath = this.dstPath.concat(keyPath.substring(this.srcPath.length()));
                try {
                    this.adapterImpl.rename(this.bucket, keyPath, newPath);
                }
                catch (OMException ome) {
                    LOG.error("Key rename failed for source key: {} to destination key: {}.", new Object[]{keyPath, newPath, ome});
                    if (OMException.ResultCodes.KEY_ALREADY_EXISTS == ome.getResult() || OMException.ResultCodes.KEY_RENAME_ERROR == ome.getResult() || OMException.ResultCodes.KEY_NOT_FOUND == ome.getResult()) {
                        return false;
                    }
                    throw ome;
                }
            }
            return true;
        }
    }
}

