/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.common.OzoneChecksumException;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class ChecksumData {
    private final ContainerProtos.ChecksumType type;
    private final int bytesPerChecksum;
    private final List<ByteString> checksums;

    public ChecksumData(ContainerProtos.ChecksumType checksumType, int bytesPerChecksum) {
        this(checksumType, bytesPerChecksum, Collections.emptyList());
    }

    public ChecksumData(ContainerProtos.ChecksumType checksumType, int bytesPerChecksum, List<ByteString> checksums) {
        this.type = checksumType;
        this.bytesPerChecksum = bytesPerChecksum;
        this.checksums = Collections.unmodifiableList(checksums);
    }

    public ContainerProtos.ChecksumType getChecksumType() {
        return this.type;
    }

    public int getBytesPerChecksum() {
        return this.bytesPerChecksum;
    }

    public List<ByteString> getChecksums() {
        return this.checksums;
    }

    public ContainerProtos.ChecksumData getProtoBufMessage() {
        ContainerProtos.ChecksumData.Builder checksumProtoBuilder = ContainerProtos.ChecksumData.newBuilder().setType(this.type).setBytesPerChecksum(this.bytesPerChecksum);
        checksumProtoBuilder.addAllChecksums(this.checksums);
        return checksumProtoBuilder.build();
    }

    public static ChecksumData getFromProtoBuf(ContainerProtos.ChecksumData checksumDataProto) {
        Preconditions.checkNotNull((Object)checksumDataProto);
        return new ChecksumData(checksumDataProto.getType(), checksumDataProto.getBytesPerChecksum(), checksumDataProto.getChecksumsList());
    }

    public boolean verifyChecksumDataMatches(ChecksumData that, int startIndex) throws OzoneChecksumException {
        if (this.checksums.isEmpty()) {
            throw new OzoneChecksumException("Original checksumData has no checksums");
        }
        if (that.checksums.isEmpty()) {
            throw new OzoneChecksumException("Computed checksumData has no checksums");
        }
        int numChecksums = that.checksums.size();
        try {
            for (int index = 0; index < numChecksums; ++index) {
                if (ChecksumData.matchChecksumAtIndex(this.checksums.get(startIndex + index), that.checksums.get(index))) continue;
                throw new OzoneChecksumException(index);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new OzoneChecksumException("Computed checksum has " + numChecksums + " number of checksums. Original checksum has " + (this.checksums.size() - startIndex) + " number of checksums starting from index " + startIndex);
        }
        return true;
    }

    private static boolean matchChecksumAtIndex(ByteString expectedChecksumAtIndex, ByteString computedChecksumAtIndex) {
        return expectedChecksumAtIndex.equals((Object)computedChecksumAtIndex);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChecksumData)) {
            return false;
        }
        ChecksumData that = (ChecksumData)obj;
        if (!this.type.equals((Object)that.getChecksumType())) {
            return false;
        }
        if (this.bytesPerChecksum != that.getBytesPerChecksum()) {
            return false;
        }
        if (this.checksums.size() != that.checksums.size()) {
            return false;
        }
        for (int index = 0; index < this.checksums.size(); ++index) {
            if (ChecksumData.matchChecksumAtIndex(this.checksums.get(index), that.checksums.get(index))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hc = new HashCodeBuilder();
        hc.append((Object)this.type);
        hc.append(this.bytesPerChecksum);
        hc.append(this.checksums.toArray());
        return hc.toHashCode();
    }
}

